/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.mq.config.CloudtMqProperties;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.springframework.boot.context.event.ApplicationContextInitializedEvent;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.event.SmartApplicationListener;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.lang.NonNull;

class CloudtMqEnvironmentListener
implements SmartApplicationListener,
Ordered {
    private static final Logger logger = CloudtBootLoggerFactory.MQ.getLogger(CloudtMqEnvironmentListener.class);

    CloudtMqEnvironmentListener() {
    }

    public boolean supportsEventType(Class<? extends ApplicationEvent> eventType) {
        return eventType.isAssignableFrom(ApplicationContextInitializedEvent.class);
    }

    public void onApplicationEvent(@NonNull ApplicationEvent event) {
        if (event instanceof ApplicationContextInitializedEvent) {
            ConfigurableEnvironment env = ((ApplicationContextInitializedEvent)event).getApplicationContext().getEnvironment();
            if (!(env instanceof StandardEnvironment)) {
                return;
            }
            StandardEnvironment environment = (StandardEnvironment)((ApplicationContextInitializedEvent)event).getApplicationContext().getEnvironment();
            PropertySource propertySource = environment.getPropertySources().get("defaultProperties");
            if (propertySource == null) {
                throw new IllegalStateException("\u7f3a\u5c11\u9ed8\u8ba4PropertySource");
            }
            Map defaultProperties = (Map)propertySource.getSource();
            this.createDefaultProperties((ConfigurableEnvironment)environment, defaultProperties);
        }
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    private Map<String, Object> createDefaultProperties(ConfigurableEnvironment environment, Map<String, Object> defaultProperties) {
        CloudtMqProperties props = (CloudtMqProperties)Binder.get((Environment)environment).bindOrCreate("elitesland.mq", CloudtMqProperties.class);
        if (Boolean.FALSE.equals(props.getEnabled())) {
            logger.warn("CloudtMQ\u5df2\u7981\u7528");
            return defaultProperties;
        }
        String topicPrefix = props.getTopicPrefix();
        String consumerGroup = props.getConsumerGroup();
        if (CharSequenceUtil.isBlank((CharSequence)consumerGroup)) {
            consumerGroup = this.createConsumerGroup(environment, topicPrefix);
        }
        String topicName = CharSequenceUtil.blankToDefault((CharSequence)props.getTopicDefault(), (String)"cloudt_message_delegate_channel");
        this.createTopicBinding(defaultProperties, consumerGroup, topicPrefix, topicName);
        if (CollUtil.isNotEmpty(props.getTopicMappings())) {
            HashSet<String> existsTopics = new HashSet<String>();
            existsTopics.add(topicName);
            for (CloudtMqProperties.TopicMapping topicMapping : props.getTopicMappings()) {
                Assert.notBlank((CharSequence)topicMapping.getTopic(), (String)"topicMapping\u4e2dtopic\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                Assert.notEmpty(topicMapping.getChannels(), (String)"topicMapping\u4e2dchannels\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
                if (existsTopics.contains(topicMapping.getTopic())) {
                    logger.warn("\u5b58\u5728\u91cd\u590d\u7684\u6620\u5c04\uff1a{}", (Object)topicMapping.getTopic());
                    continue;
                }
                existsTopics.add(topicMapping.getTopic());
                String tempGroup = topicMapping.getConsumerGroup();
                if (CharSequenceUtil.isBlank((CharSequence)tempGroup)) {
                    tempGroup = this.createConsumerGroup(environment, topicPrefix + topicMapping.getTopic());
                }
                this.createTopicBinding(defaultProperties, tempGroup, topicPrefix, topicMapping.getTopic());
            }
        }
        logger.info("CloudtMq: consumer group is {}, default topic is {}, mappings is {}", new Object[]{consumerGroup, topicName, props.getTopicMappings()});
        return defaultProperties;
    }

    private void createTopicBinding(Map<String, Object> defaultProperties, String consumerGroup, String topicPrefix, String topicName) {
        String topic = CharSequenceUtil.isBlank((CharSequence)topicPrefix) ? topicName : topicPrefix + topicName;
        defaultProperties.put("spring.cloud.stream.bindings." + topicName + "_output.destination", topic);
        defaultProperties.put("spring.cloud.stream.bindings." + topicName + "_output.producer.error-channel-enabled", true);
        defaultProperties.put("spring.cloud.stream.bindings." + topicName + "_input.destination", topic);
        defaultProperties.put("spring.cloud.stream.bindings." + topicName + "_input.group", consumerGroup);
    }

    private String createConsumerGroup(ConfigurableEnvironment environment, String topicPrefix) {
        String appName = environment.getProperty("spring.application.name");
        if (CharSequenceUtil.isBlank((CharSequence)appName)) {
            logger.error("\u5e94\u7528\u540d\u79f0\u4e3a\u7a7a\uff1aspring.application.name");
            appName = "unknown";
        }
        return (CharSequenceUtil.isBlank((CharSequence)topicPrefix) ? "" : topicPrefix) + "cloudt_message_consumer_" + appName;
    }
}

