/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mq.config.support.queue.messagechannel;

import com.elitescloud.boot.mq.config.support.queue.messagechannel.MessageChannelMqProvider;
import com.elitescloud.boot.util.ArrayUtil;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.stream.binding.AbstractBindableProxyFactory;
import org.springframework.cloud.stream.binding.BoundTargetHolder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHeaders;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.MessageBuilder;

public class CloudtBindableProxyFactory
extends AbstractBindableProxyFactory
implements InitializingBean {
    private final String[] inputNames;
    private MessageChannelMqProvider messageChannelMqProvider;
    private BeanFactory beanFactory;

    public CloudtBindableProxyFactory(Class<?> type, String[] inputNames) {
        super(type);
        this.inputNames = inputNames;
    }

    public void afterPropertiesSet() throws Exception {
        if (ArrayUtil.isEmpty((Object[])this.inputNames)) {
            return;
        }
        this.populateBindingTargetFactories(this.beanFactory);
        for (String inputName : this.inputNames) {
            SubscribableChannel subscriptionChannel = (SubscribableChannel)this.getBindingTargetFactory(MessageChannel.class).createInput(inputName);
            subscriptionChannel.subscribe(message -> {
                String payload = message.getPayload() instanceof byte[] ? new String((byte[])message.getPayload()) : message.getPayload().toString();
                Message cloudtMessage = MessageBuilder.createMessage((Object)payload, (MessageHeaders)message.getHeaders());
                this.messageChannelMqProvider.consumer((Message<String>)cloudtMessage);
            });
            this.inputHolders.put(inputName, new BoundTargetHolder((Object)subscriptionChannel, true));
        }
    }

    @Autowired
    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    @Autowired
    public void setMessageChannelMqProvider(MessageChannelMqProvider messageChannelMqProvider) {
        this.messageChannelMqProvider = messageChannelMqProvider;
    }
}

