/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mybatis.config;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.autoconfigure.MybatisPlusInnerInterceptorAutoConfiguration;
import com.baomidou.mybatisplus.core.incrementer.IdentifierGenerator;
import com.baomidou.mybatisplus.extension.plugins.inner.PaginationInnerInterceptor;
import com.elitescloud.boot.data.util.DatabaseUtil;
import com.elitescloud.boot.mybatis.config.CloudtMybatisProperties;
import com.elitescloud.boot.mybatis.config.support.CloudtDataPermissionInterceptor;
import com.elitescloud.boot.mybatis.config.support.CloudtMetaObjectHandler;
import com.elitescloud.boot.provider.IdFactory;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.orm.jpa.vendor.Database;

@AutoConfiguration(before={MybatisPlusInnerInterceptorAutoConfiguration.class})
@EnableConfigurationProperties(value={CloudtMybatisProperties.class})
public class CloudtMybatisAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(CloudtMybatisAutoConfiguration.class);

    @Bean
    public PaginationInnerInterceptor paginationInnerInterceptor(DataSource dataSource) {
        Database database = DatabaseUtil.getDatabaseType((DataSource)dataSource);
        DbType dbType = null;
        switch (database) {
            case MYSQL: {
                dbType = DbType.MYSQL;
                break;
            }
            case POSTGRESQL: {
                dbType = DbType.POSTGRE_SQL;
                break;
            }
            case ORACLE: {
                dbType = DbType.ORACLE;
                break;
            }
            case SQL_SERVER: {
                dbType = DbType.SQL_SERVER;
                break;
            }
            case DB2: {
                dbType = DbType.DB2;
                break;
            }
            case H2: {
                dbType = DbType.H2;
                break;
            }
            default: {
                logger.warn("Unsupported database type: {}", (Object)database);
            }
        }
        return new PaginationInnerInterceptor(dbType);
    }

    @Bean
    public IdentifierGenerator identifierGenerator() {
        return entity -> IdFactory.generateLong();
    }

    @Bean
    public CloudtMetaObjectHandler cloudtMetaObjectHandler() {
        return new CloudtMetaObjectHandler();
    }

    @Bean
    public CloudtDataPermissionInterceptor customDataPermissionInterceptor() {
        return new CloudtDataPermissionInterceptor();
    }
}

