/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mybatis.config.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.baomidou.mybatisplus.extension.parser.JsqlParserGlobal;
import com.baomidou.mybatisplus.extension.plugins.inner.InnerInterceptor;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.data.common.DataSecurity;
import com.elitescloud.boot.datasecurity.common.DataSecurityUtil;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleConditionEnum;
import com.elitescloud.boot.datasecurity.dpr.content.DprRuleRelationEnum;
import com.elitescloud.boot.mybatis.expression.RawStringExpression;
import com.elitescloud.boot.mybatis.util.MyBatisUtil;
import com.elitescloud.cloudt.system.dto.BaseDataSecurityRuleDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiDataRuleListQueryDTO;
import com.elitescloud.cloudt.system.dto.SysDprRoleApiRowColumnRuleDTO;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.session.SqlSessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class CloudtDataPermissionInterceptor
implements InnerInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(CloudtDataPermissionInterceptor.class);

    public void beforeQuery(Executor executor, MappedStatement ms, Object parameter, RowBounds rowBounds, ResultHandler resultHandler, BoundSql boundSql) throws SQLException {
        if (ms.getSqlCommandType() != SqlCommandType.SELECT) {
            return;
        }
        Method method = this.getDataSecurityMethod(ms);
        if (method == null) {
            return;
        }
        SysDprRoleApiRowColumnRuleDTO dataPermission = DataSecurityUtil.getDataPermission();
        if (dataPermission == null || CollUtil.isEmpty((Collection)dataPermission.getSysDprRoleApiDataRuleListQueryDTO())) {
            return;
        }
        DataSecurity dataSecurity = method.getAnnotation(DataSecurity.class);
        Class entityClass = dataSecurity.entityClass();
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)entityClass);
        Assert.notNull((Object)tableInfo, () -> "\u5b9e\u4f53[" + entityClass.getName() + "]\u672a\u627e\u5230\u5bf9\u5e94\u7684\u8868\u4fe1\u606f");
        Statement statement = null;
        try {
            statement = JsqlParserGlobal.parse((String)boundSql.getSql());
        }
        catch (JSQLParserException e) {
            logger.error("\u89e3\u6790SQL\u5f02\u5e38\uff1a{}, {}", new Object[]{ms.getId(), boundSql.getSql(), e});
            throw new RuntimeException("\u89e3\u6790SQL\u5f02\u5e38", e);
        }
        if (!(statement instanceof Select)) {
            return;
        }
        PlainSelect selectBody = (PlainSelect)((Select)statement).getSelectBody();
        Table table = this.lookForTable(dataSecurity, tableInfo, selectBody);
        if (table == null) {
            throw new RuntimeException("\u672a\u67e5\u8be2\u5230\u6570\u636e\u6743\u9650\u5bf9\u5e94\u7684\u8868\uff1a" + ms.getId() + "," + tableInfo.getTableName());
        }
        MybatisConfiguration configuration = (MybatisConfiguration)((SqlSessionFactory)SpringContextHolder.getBean(SqlSessionFactory.class)).getConfiguration();
        Map parameterMap = (Map)boundSql.getParameterObject();
        if (parameterMap == null) {
            parameterMap = boundSql.getAdditionalParameters();
        }
        ArrayList<ParameterMapping> parameterMappings = new ArrayList<ParameterMapping>(boundSql.getParameterMappings() == null ? Collections.emptyList() : boundSql.getParameterMappings());
        Map<String, List<SysDprRoleApiDataRuleListQueryDTO>> rolePermissionMap = dataPermission.getSysDprRoleApiDataRuleListQueryDTO().stream().collect(Collectors.groupingBy(BaseDataSecurityRuleDTO::getRoleCode));
        AtomicInteger paramIndex = new AtomicInteger(0);
        ArrayList<Expression> expressions = new ArrayList<Expression>(64);
        for (Map.Entry<String, List<SysDprRoleApiDataRuleListQueryDTO>> rolePermissionEntry : rolePermissionMap.entrySet()) {
            DprRuleRelationEnum relation = DataSecurityUtil.getRelation(rolePermissionEntry.getValue());
            Expression exp = this.buildPredicate(table, tableInfo, relation, rolePermissionEntry.getValue(), configuration, parameterMap, paramIndex, parameterMappings);
            if (exp == null) continue;
            expressions.add(exp);
        }
        if (expressions.isEmpty()) {
            return;
        }
        Expression dprExpression = this.buildGroupExpression(expressions, false);
        Expression where = selectBody.getWhere() == null ? dprExpression : new AndExpression(selectBody.getWhere(), dprExpression);
        selectBody.setWhere(where);
        PluginUtils.MPBoundSql mpbs = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpbs.parameterMappings(parameterMappings);
        mpbs.sql(selectBody.toString());
    }

    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        BoundSql boundSql = sh.getBoundSql();
        if (boundSql.getParameterObject() == null) {
            MetaObject metaBoundSql = SystemMetaObject.forObject((Object)boundSql);
            metaBoundSql.setValue("parameterObject", new HashMap(64));
        }
    }

    private Expression buildPredicate(Table table, TableInfo tableInfo, DprRuleRelationEnum relation, List<SysDprRoleApiDataRuleListQueryDTO> ruleList, MybatisConfiguration configuration, Map<String, Object> parameterMap, AtomicInteger paramIndex, List<ParameterMapping> parameterMappings) {
        if (CollUtil.isEmpty(ruleList)) {
            return null;
        }
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        Expression exp = null;
        for (SysDprRoleApiDataRuleListQueryDTO rule : ruleList) {
            if (Boolean.TRUE.equals(rule.getRuleGroup())) {
                exp = this.buildPredicate(table, tableInfo, DprRuleRelationEnum.valueOf((String)rule.getDprRuleRelation()), rule.getGroupRules(), configuration, parameterMap, paramIndex, parameterMappings);
                if (exp == null) continue;
                expressions.add(exp);
                continue;
            }
            TableFieldInfo fieldInfo = tableInfo.getFieldList().stream().filter(t -> t.getProperty().equals(rule.getDprRuleField())).findFirst().orElse(null);
            if (fieldInfo == null) continue;
            String[] values = rule.getDprRuleValue().split(",");
            InExpression expression = new InExpression();
            expression.setLeftExpression((Expression)new Column(table, fieldInfo.getColumn()));
            expression.setRightExpression((Expression)new RawStringExpression(this.generatePlaceholder(paramIndex.getAndAdd(values.length), values.length)));
            DprRuleConditionEnum condition = DprRuleConditionEnum.valueOf((String)rule.getDprRuleCondition());
            switch (condition) {
                case Equal: 
                case InList: {
                    break;
                }
                case NotEqual: 
                case NotIn: {
                    expression.setNot(true);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("\u4e0d\u652f\u6301\u7684\u6761\u4ef6\uff1a" + condition);
                }
            }
            expressions.add((Expression)expression);
            this.addParams(fieldInfo, values, configuration, parameterMap, paramIndex, parameterMappings);
        }
        return this.buildGroupExpression(expressions, relation == DprRuleRelationEnum.DPR_RULE_RELATION_AND);
    }

    private Expression buildGroupExpression(List<Expression> expressionList, boolean and) {
        if (CollUtil.isEmpty(expressionList)) {
            return null;
        }
        if (expressionList.size() == 1) {
            return expressionList.get(0);
        }
        Expression result = null;
        for (Expression expression : expressionList) {
            result = result == null ? expression : (and ? new AndExpression(result, expression) : new OrExpression(result, expression));
        }
        return new Parenthesis(result);
    }

    private void addParams(TableFieldInfo fieldInfo, String[] values, MybatisConfiguration configuration, Map<String, Object> parameterMap, AtomicInteger paramIndex, List<ParameterMapping> parameterMappings) {
        String prefix = "__cloudtDpr_";
        for (String value : values) {
            String name = prefix + paramIndex.getAndIncrement() + "_" + fieldInfo.getProperty();
            parameterMappings.add(new ParameterMapping.Builder((Configuration)configuration, name, fieldInfo.getPropertyType()).build());
            parameterMap.put(name, this.convertParam(value, fieldInfo.getPropertyType()));
        }
    }

    private Object convertParam(String value, Class<?> clazz) {
        if (clazz == String.class) {
            return value;
        }
        if (clazz == Integer.class || clazz == Integer.TYPE) {
            return Integer.parseInt(value);
        }
        if (clazz == Long.class || clazz == Long.TYPE) {
            return Long.parseLong(value);
        }
        if (clazz == Double.class || clazz == Double.TYPE) {
            return Double.parseDouble(value);
        }
        if (clazz == Float.class || clazz == Float.TYPE) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (clazz == Boolean.class || clazz == Boolean.TYPE) {
            return Boolean.parseBoolean(value);
        }
        return value;
    }

    private String generatePlaceholder(int startIndex, int size) {
        StringJoiner joiner = new StringJoiner(",", "(", ")");
        for (int i = 0; i < size; ++i) {
            joiner.add("?");
        }
        return joiner.toString();
    }

    private Table lookForTable(DataSecurity dataSecurity, TableInfo tableInfo, PlainSelect selectBody) {
        Table table;
        boolean hasAlias = CharSequenceUtil.isNotBlank((CharSequence)dataSecurity.tableAlias());
        String tableName = tableInfo.getTableName();
        if (tableName.equalsIgnoreCase((table = (Table)selectBody.getFromItem()).getName())) {
            if (hasAlias) {
                if (table.getAlias() != null && dataSecurity.tableAlias().equals(table.getAlias().getName())) {
                    return table;
                }
            } else {
                return table;
            }
        }
        if (CollUtil.isEmpty((Collection)selectBody.getJoins())) {
            return null;
        }
        for (Join join : selectBody.getJoins()) {
            table = (Table)join.getRightItem();
            if (!tableName.equalsIgnoreCase(table.getName())) continue;
            if (hasAlias) {
                if (table.getAlias() == null || !dataSecurity.tableAlias().equals(table.getAlias().getName())) continue;
                return table;
            }
            return table;
        }
        return null;
    }

    private Method getDataSecurityMethod(MappedStatement ms) {
        List<Method> methods = MyBatisUtil.getMethodsByMapperMethodId(ms.getId());
        List targetMethods = methods.stream().filter(t -> t.isAnnotationPresent(DataSecurity.class)).collect(Collectors.toList());
        if (targetMethods.isEmpty()) {
            return null;
        }
        if (targetMethods.size() != methods.size()) {
            logger.warn("\u6570\u636e\u6743\u9650\u62e6\u622a\u65f6\u53d1\u73b0\u591a\u4e2a\u91cd\u540d\u7684\u65b9\u6cd5\uff0c\u8bf7\u6ce8\u610f\u53ef\u80fd\u5b58\u5728\u98ce\u9669\uff1a{}", (Object)ms.getId());
        }
        return (Method)targetMethods.get(0);
    }
}

