/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.mybatis.config.support.interceptor;

import cn.hutool.core.collection.CollUtil;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.data.support.audit.CustomAuditUtil;
import com.elitescloud.boot.mybatis.common.AbstractCloudtInnerInterceptor;
import com.elitescloud.boot.mybatis.config.support.interceptor.CloudtLogicDeleteInterceptor;
import com.elitescloud.boot.mybatis.expression.RawStringExpression;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import net.sf.jsqlparser.statement.update.UpdateSet;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.session.Configuration;
import org.slf4j.Logger;

public class CloudtAuditInterceptor
extends AbstractCloudtInnerInterceptor {
    private static final Logger logger = CloudtBootLoggerFactory.REPO_MYBATIS.getLogger(CloudtLogicDeleteInterceptor.class);

    @Override
    public void beforeGetBoundSql(StatementHandler sh) {
        if (super.hasExecuted(sh, CloudtAuditInterceptor.class)) {
            return;
        }
        super.beforeGetBoundSql(sh);
        this.dealAudit(sh);
    }

    @Override
    public void beforePrepare(StatementHandler sh, Connection connection, Integer transactionTimeout) {
        if (super.hasExecuted(sh, CloudtAuditInterceptor.class)) {
            return;
        }
        super.beforePrepare(sh, connection, transactionTimeout);
        this.dealAudit(sh);
    }

    private void dealAudit(StatementHandler sh) {
        PluginUtils.MPStatementHandler mpSh = PluginUtils.mpStatementHandler((StatementHandler)sh);
        MappedStatement ms = mpSh.mappedStatement();
        if (ms.getSqlCommandType() == SqlCommandType.INSERT) {
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            this.dealForInsert((Insert)this.parseSql(ms, mpSh.mPBoundSql().sql()), mpBs);
            return;
        }
        if (ms.getSqlCommandType() == SqlCommandType.UPDATE) {
            PluginUtils.MPBoundSql mpBs = mpSh.mPBoundSql();
            this.dealForUpdate((Update)this.parseSql(ms, mpBs.sql()), mpBs);
            return;
        }
    }

    private void dealForInsert(Insert statement, PluginUtils.MPBoundSql mpbs) {
        List<String> fillFields = this.getProps().getAutoInsertFillFields();
        if (fillFields.isEmpty()) {
            return;
        }
        Table table = statement.getTable();
        TableInfo tableInfo = super.getTableInfo(table.getName());
        Map fieldInfoMap = super.getFieldInfos(table.getName()).stream().collect(Collectors.toMap(TableFieldInfo::getProperty, Function.identity(), (t1, t2) -> t1));
        ArrayList<Column> columns = statement.getColumns();
        if (columns == null) {
            columns = new ArrayList<Column>();
            statement.setColumns(columns);
        }
        MybatisConfiguration configuration = super.getMybatisConfiguration();
        HashMap<String, Object> parameterMap = mpbs.additionalParameters();
        if (parameterMap == null) {
            parameterMap = new HashMap<String, Object>();
        }
        List parameterMappings = mpbs.parameterMappings();
        Object entity = this.obtainEntity(tableInfo, true, parameterMap);
        AtomicInteger paramIndex = new AtomicInteger(parameterMappings.size());
        for (String fillField : fillFields) {
            boolean exists;
            TableFieldInfo fileField = (TableFieldInfo)fieldInfoMap.get(fillField);
            if (fileField == null || (exists = columns.stream().anyMatch(t -> t.getColumnName().equalsIgnoreCase(fileField.getColumn()) && this.isSameTable(t.getTable(), table)))) continue;
            columns.add(new Column(fileField.getColumn()));
            this.addInsertValue(statement);
            Object value = tableInfo.getPropertyValue(entity, fillField);
            this.addParam(fileField, value, configuration, parameterMap, paramIndex, parameterMappings);
        }
        mpbs.sql(statement.toString());
        mpbs.parameterMappings(parameterMappings);
    }

    private void dealForUpdate(Update statement, PluginUtils.MPBoundSql mpbs) {
        List<String> fillFields = this.getProps().getAutoUpdateFillFields();
        if (fillFields.isEmpty()) {
            return;
        }
        Table table = statement.getTable();
        TableInfo tableInfo = super.getTableInfo(table.getName());
        Map fieldInfoMap = super.getFieldInfos(table.getName()).stream().collect(Collectors.toMap(TableFieldInfo::getProperty, Function.identity(), (t1, t2) -> t1));
        ArrayList updateSets = statement.getUpdateSets();
        MybatisConfiguration configuration = super.getMybatisConfiguration();
        HashMap<String, Object> parameterMap = mpbs.additionalParameters();
        if (parameterMap == null) {
            parameterMap = new HashMap<String, Object>();
        }
        List parameterMappings = mpbs.parameterMappings();
        Object entity = this.obtainEntity(tableInfo, false, parameterMap);
        AtomicInteger paramIndex = new AtomicInteger(this.findUpdatedSetsSize(updateSets));
        for (String fillField : fillFields) {
            boolean exists;
            TableFieldInfo fileField = (TableFieldInfo)fieldInfoMap.get(fillField);
            if (fileField == null || (exists = updateSets.stream().anyMatch(t -> t.getColumns().stream().anyMatch(column -> column.getColumnName().equalsIgnoreCase(fileField.getColumn()) && this.isSameTable(column.getTable(), table))))) continue;
            updateSets.add(new UpdateSet(new Column(fileField.getColumn()), (Expression)new RawStringExpression("?")));
            Object value = tableInfo.getPropertyValue(entity, fillField);
            this.addParam(fileField, value, configuration, parameterMap, paramIndex, parameterMappings);
        }
        mpbs.sql(statement.toString());
        mpbs.parameterMappings(parameterMappings);
    }

    private void addInsertValue(Insert insert) {
        Select select = insert.getSelect();
        if (insert.getItemsList() != null) {
            ItemsList itemsList = insert.getItemsList();
            RawStringExpression exp = new RawStringExpression("?");
            if (!(itemsList instanceof MultiExpressionList)) {
                List expressions = ((ExpressionList)itemsList).getExpressions();
                if (CollectionUtils.isNotEmpty((Collection)expressions)) {
                    int len = expressions.size();
                    for (int i = 0; i < len; ++i) {
                        Expression expression = (Expression)expressions.get(i);
                        if (expression instanceof RowConstructor) {
                            ((RowConstructor)expression).getExprList().getExpressions().add(exp);
                            continue;
                        }
                        if (expression instanceof Parenthesis) {
                            RowConstructor rowConstructor = new RowConstructor().withExprList(new ExpressionList(new Expression[]{((Parenthesis)expression).getExpression(), exp}));
                            expressions.set(i, rowConstructor);
                            continue;
                        }
                        if (len - 1 != i) continue;
                        expressions.add(exp);
                    }
                } else {
                    expressions.add(exp);
                }
            }
        } else {
            throw ExceptionUtils.mpe((String)"Failed to process multiple-table update, please exclude the tableName or statementId", (Object[])new Object[0]);
        }
    }

    private int findUpdatedSetsSize(ArrayList<UpdateSet> updateSets) {
        int index = 0;
        if (CollUtil.isEmpty(updateSets)) {
            return 0;
        }
        for (UpdateSet updateSet : updateSets) {
            for (Expression expression : updateSet.getExpressions()) {
                if (!expression.toString().contains("?")) continue;
                ++index;
            }
        }
        return index;
    }

    private Object obtainEntity(TableInfo tableInfo, boolean insert, Map<String, Object> parameterMap) {
        Object entity = this.findExistsEntity(tableInfo.getEntityType(), parameterMap);
        if (entity != null) {
            return entity;
        }
        entity = tableInfo.newInstance();
        if (insert) {
            CustomAuditUtil.markCreated((Object)entity);
        } else {
            CustomAuditUtil.markModified((Object)entity);
        }
        return entity;
    }

    private Object findExistsEntity(Class<?> entityClass, Map<String, Object> parameterMap) {
        Object entity;
        if (parameterMap == null) {
            return null;
        }
        Object objectKey = parameterMap.get("_parameter");
        if (objectKey == null) {
            return null;
        }
        if (entityClass.isAssignableFrom(objectKey.getClass())) {
            return objectKey;
        }
        if (objectKey instanceof Map && (entity = ((Map)objectKey).get("et")) != null && entityClass.isAssignableFrom(entity.getClass())) {
            return entity;
        }
        return null;
    }

    private void addParam(TableFieldInfo fieldInfo, Object value, MybatisConfiguration configuration, Map<String, Object> parameterMap, AtomicInteger paramIndex, List<ParameterMapping> parameterMappings) {
        String prefix = "__cloudtAudit_";
        int index = paramIndex.getAndIncrement();
        String name = prefix + index + "_" + fieldInfo.getProperty();
        parameterMappings.add(index, new ParameterMapping.Builder((Configuration)configuration, name, fieldInfo.getPropertyType()).build());
        parameterMap.put(name, value);
    }
}

