/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.openfeign.config;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.openfeign.config.CloudtBlockingLoadBalancerClient;
import com.elitescloud.boot.openfeign.config.CloudtHeaderInterceptor;
import com.elitescloud.boot.openfeign.config.CloudtOpenFeignProperties;
import com.elitescloud.boot.openfeign.config.CloudtTargeter;
import com.elitescloud.boot.openfeign.config.FeignAuthenticationContextInterceptor;
import com.elitescloud.boot.openfeign.config.FeignTraceLogInterceptor;
import com.elitescloud.boot.openfeign.config.TargeterProxy;
import com.elitescloud.boot.openfeign.config.web.FeignClientRequestMappingHandlerMappingCustomizer;
import feign.Feign;
import feign.Response;
import feign.Target;
import feign.codec.ErrorDecoder;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.loadbalancer.LoadBalancerClient;
import org.springframework.cloud.client.loadbalancer.reactive.ReactiveLoadBalancer;
import org.springframework.cloud.loadbalancer.config.BlockingLoadBalancerClientAutoConfiguration;
import org.springframework.cloud.loadbalancer.support.LoadBalancerClientFactory;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignAutoConfiguration;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.FeignContext;
import org.springframework.cloud.openfeign.Targeter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration
@EnableConfigurationProperties(value={CloudtOpenFeignProperties.class})
@EnableFeignClients(basePackages={"com.elitescloud", "com.elitesland"})
@AutoConfigureBefore(value={BlockingLoadBalancerClientAutoConfiguration.class, FeignAutoConfiguration.class})
class CloudtOpenFeignAutoConfiguration {
    private static final Logger log = LogManager.getLogger(CloudtOpenFeignAutoConfiguration.class);
    @Value(value="${spring.application.name:#{null}}")
    private String applicationName;
    @Value(value="${server.port:8080}")
    private Integer port;
    private final CloudtOpenFeignProperties properties;

    public CloudtOpenFeignAutoConfiguration(CloudtOpenFeignProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnProperty(prefix="elitesland.openfeign", name={"direct-local"}, havingValue="true", matchIfMissing=true)
    public CloudtTargeter cloudtTargeter() {
        TargeterProxy targeterProxy = new TargeterProxy(new Targeter(){

            public <T> T target(FeignClientFactoryBean factory, Feign.Builder feign, FeignContext context, Target.HardCodedTarget<T> target) {
                return (T)feign.target(target);
            }
        }, this.buildProxyServices(), this.properties);
        return new CloudtTargeter(targeterProxy);
    }

    @Bean
    public ErrorDecoder errorDecoder() {
        return new ErrorDecoder.Default(){

            public Exception decode(String methodKey, Response response) {
                Exception exp = super.decode(methodKey, response);
                log.error("OpenFeign\u5904\u7406\u5f02\u5e38\uff1a", (Throwable)exp);
                return exp;
            }
        };
    }

    @Bean
    public FeignClientRequestMappingHandlerMappingCustomizer feignClientRequestMappingHandlerMappingCustomizer() {
        return new FeignClientRequestMappingHandlerMappingCustomizer();
    }

    @Bean
    @ConditionalOnClass(name={"com.elitescloud.cloudt.authorization.core.SecurityContextUtil"})
    public FeignAuthenticationContextInterceptor feignAuthenticationContextInterceptor() {
        return new FeignAuthenticationContextInterceptor();
    }

    @Bean
    public CloudtHeaderInterceptor cloudtHeaderInterceptor() {
        return new CloudtHeaderInterceptor();
    }

    @Bean
    public FeignTraceLogInterceptor feignLogTraceHandler() {
        return new FeignTraceLogInterceptor(this.applicationName);
    }

    @Bean
    public LoadBalancerClient blockingLoadBalancerClient(LoadBalancerClientFactory loadBalancerClientFactory) {
        return new CloudtBlockingLoadBalancerClient(this.applicationName, this.port, (ReactiveLoadBalancer.Factory<ServiceInstance>)loadBalancerClientFactory, this.properties);
    }

    private Set<String> buildProxyServices() {
        HashSet<String> services = new HashSet<String>();
        if (CollUtil.isNotEmpty(this.properties.getDirectLocalServices())) {
            boolean proxyAll = this.properties.getDirectLocalServices().stream().anyMatch("*"::equals);
            if (proxyAll) {
                services.add("*");
                return services;
            }
            services.addAll(this.properties.getDirectLocalServices());
        }
        if (StringUtils.hasText((String)this.applicationName)) {
            services.add(this.applicationName);
        }
        return services;
    }
}

