/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.redis.redisson;

import java.util.Collection;
import org.redisson.config.CloudtSingleServerConfig;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReplicatedServersConfig;
import org.redisson.config.SentinelServersConfig;
import org.redisson.config.SingleServerConfig;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class RedissonCustomProperties {
    public static final String CONFIG_PREFIX = "elitesland.redis.redisson";
    private Boolean enabled;
    private final ClusterServersConfig clusterServersConfig = new ClusterServersConfig();
    private final SingleServerConfig singleServerConfig = new CloudtSingleServerConfig();
    private final MasterSlaveServersConfig masterSlaveServersConfig = new MasterSlaveServersConfig();
    private final ReplicatedServersConfig replicatedServersConfig = new ReplicatedServersConfig();
    private final SentinelServersConfig sentinelServersConfig = new SentinelServersConfig();

    public Boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public ClusterServersConfig getClusterServersConfig() {
        return this.clusterServersConfig;
    }

    public SingleServerConfig getSingleServerConfig() {
        return this.singleServerConfig;
    }

    public MasterSlaveServersConfig getMasterSlaveServersConfig() {
        return this.masterSlaveServersConfig;
    }

    public ReplicatedServersConfig getReplicatedServersConfig() {
        return this.replicatedServersConfig;
    }

    public SentinelServersConfig getSentinelServersConfig() {
        return this.sentinelServersConfig;
    }

    public Config buildConfig() {
        CustomConfig config = new CustomConfig();
        if (!CollectionUtils.isEmpty((Collection)this.getClusterServersConfig().getNodeAddresses())) {
            config.setClusterServersConfig(this.getClusterServersConfig());
            return config;
        }
        if (StringUtils.hasText((String)this.getSingleServerConfig().getAddress())) {
            config.setSingleServerConfig(this.getSingleServerConfig());
            return config;
        }
        if (StringUtils.hasText((String)this.getMasterSlaveServersConfig().getMasterAddress())) {
            config.setMasterSlaveServersConfig(this.getMasterSlaveServersConfig());
            return config;
        }
        if (!CollectionUtils.isEmpty((Collection)this.getReplicatedServersConfig().getNodeAddresses())) {
            config.setReplicatedServersConfig(this.getReplicatedServersConfig());
            return config;
        }
        if (!CollectionUtils.isEmpty((Collection)this.getSentinelServersConfig().getSentinelAddresses())) {
            config.setSentinelServersConfig(this.getSentinelServersConfig());
            return config;
        }
        return null;
    }

    static class CustomConfig
    extends Config {
        CustomConfig() {
        }

        public void setClusterServersConfig(ClusterServersConfig clusterServersConfig) {
            super.setClusterServersConfig(clusterServersConfig);
        }

        public void setReplicatedServersConfig(ReplicatedServersConfig replicatedServersConfig) {
            super.setReplicatedServersConfig(replicatedServersConfig);
        }

        public void setSingleServerConfig(SingleServerConfig singleConnectionConfig) {
            super.setSingleServerConfig(singleConnectionConfig);
        }

        public void setSentinelServersConfig(SentinelServersConfig sentinelConnectionConfig) {
            super.setSentinelServersConfig(sentinelConnectionConfig);
        }

        public void setMasterSlaveServersConfig(MasterSlaveServersConfig masterSlaveConnectionConfig) {
            super.setMasterSlaveServersConfig(masterSlaveConnectionConfig);
        }
    }
}

