/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.security.config;

import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.boot.support.CloudtInterceptor;
import com.elitescloud.cloudt.security.CurrentUserExtension;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.http.server.PathContainer;
import org.springframework.lang.NonNull;
import org.springframework.web.util.pattern.PathPattern;

public class CurrentUserExtensionInterceptor
implements CloudtInterceptor {
    private final List<PathPattern> excludeRequestMatcher;
    private final CurrentUserExtension userExtension;
    private final UserDetailProvider userProvider;

    public CurrentUserExtensionInterceptor(ObjectProvider<CurrentUserExtension> userExtensionObjectProvider, UserDetailProvider userProvider) {
        this.userExtension = (CurrentUserExtension)userExtensionObjectProvider.getIfAvailable();
        this.excludeRequestMatcher = this.createExcludeRequestMatcher();
        this.userProvider = userProvider;
    }

    public boolean preHandle(@NonNull HttpServletRequest request, @NonNull HttpServletResponse response, @NonNull Object handler) throws Exception {
        if (this.userExtension == null || this.isExclude(request)) {
            return true;
        }
        this.extensionUserInfo();
        return true;
    }

    private void extensionUserInfo() {
        GeneralUserDetails user = this.userProvider.currentUser();
        if (user == null) {
            return;
        }
        Serializable extension = this.userExtension.extension(user);
        user.setExtendInfo((Object)extension);
    }

    public int order() {
        return 1;
    }

    private boolean isExclude(HttpServletRequest request) {
        if (this.excludeRequestMatcher.isEmpty()) {
            return false;
        }
        PathContainer pathContainer = PathContainer.parsePath((String)request.getRequestURI());
        return this.excludeRequestMatcher.stream().anyMatch(t -> t.matches(pathContainer));
    }

    private List<PathPattern> createExcludeRequestMatcher() {
        HashSet paths = new HashSet(CloudtInterceptor.staticResourcePatter());
        return CloudtInterceptor.convert2RequestMatcher(paths);
    }
}

