/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.security.config;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.security.common.support.PermissionMetadataProvider;
import com.elitescloud.boot.security.config.CustomSecurityProperties;
import com.elitescloud.boot.security.config.metadata.CloudtFilterInvocationSecurityMetadataSource;
import com.elitescloud.boot.security.config.metadata.CloudtRoleVoter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDecisionVoter;
import org.springframework.security.access.vote.AffirmativeBased;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public class FilterInvocationSecurityConfig {
    private static final Logger log = LogManager.getLogger(FilterInvocationSecurityConfig.class);
    private final AuthorizationProperties authorizationProperties;
    private final CustomSecurityProperties customSecurityProperties;

    public FilterInvocationSecurityConfig(AuthorizationProperties authorizationProperties, CustomSecurityProperties customSecurityProperties) {
        this.authorizationProperties = authorizationProperties;
        this.customSecurityProperties = customSecurityProperties;
    }

    @Bean
    public RoleVoter roleVoter() {
        return new CloudtRoleVoter(this.customSecurityProperties);
    }

    @Bean
    public AccessDecisionManager accessDecisionManager(List<AccessDecisionVoter<?>> decisionVoters) {
        return new AffirmativeBased(decisionVoters);
    }

    @Bean
    public FilterInvocationSecurityMetadataSource filterInvocationSecurityMetadataSource(CustomSecurityProperties customSecurityProperties, UserDetailProvider currentUserProvider, @Autowired(required=false) RedisUtils redisUtils, PermissionMetadataProvider permissionMetadataProvider, HandlerMappingIntrospector handlerMappingIntrospector) {
        CloudtFilterInvocationSecurityMetadataSource metadataSource = new CloudtFilterInvocationSecurityMetadataSource(customSecurityProperties, currentUserProvider, permissionMetadataProvider);
        metadataSource.setAnonymous((Boolean)ObjectUtil.defaultIfNull((Object)this.authorizationProperties.getAnonymousEnabled(), (Object)false));
        metadataSource.setAllowPredicate(this.allowPredicate(handlerMappingIntrospector));
        metadataSource.setHandlerMappingIntrospector(handlerMappingIntrospector);
        return metadataSource;
    }

    @Bean
    @ConditionalOnMissingBean
    public PermissionMetadataProvider permissionMetadataProvider() {
        log.warn("\u672a\u53d1\u73b0\u6709\u6548\u7684PermissionMetadataProvider");
        return currentUser -> Collections.emptyList();
    }

    private Predicate<HttpServletRequest> allowPredicate(HandlerMappingIntrospector handlerMappingIntrospector) {
        HashSet allowUris = new HashSet(64);
        allowUris.addAll(InterceptUri.getAllowUri());
        allowUris.addAll((Collection)ObjectUtil.defaultIfNull((Object)this.authorizationProperties.getAllowList(), Collections.emptySet()));
        if (allowUris.isEmpty()) {
            return t -> false;
        }
        return request -> allowUris.stream().anyMatch(t -> new MvcRequestMatcher(handlerMappingIntrospector, t).matches(request));
    }
}

