/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.security.config.metadata;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.auth.client.common.InterceptUri;
import com.elitescloud.boot.auth.client.config.AuthorizationProperties;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.security.common.InnerRole;
import com.elitescloud.boot.security.common.support.PermissionMetadataProvider;
import com.elitescloud.boot.security.config.CustomSecurityProperties;
import com.elitescloud.boot.support.app.CloudtAppHolder;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.provider.dto.SysApiPermissionMetadataDTO;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.http.HttpServletRequest;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.access.SecurityConfig;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.intercept.FilterInvocationSecurityMetadataSource;
import org.springframework.security.web.servlet.util.matcher.MvcRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.handler.HandlerMappingIntrospector;

public class CloudtFilterInvocationSecurityMetadataSource
implements FilterInvocationSecurityMetadataSource {
    private static final Logger logger = LoggerFactory.getLogger(CloudtFilterInvocationSecurityMetadataSource.class);
    private final AuthorizationProperties authorizationProperties;
    private final CustomSecurityProperties securityProperties;
    private final PermissionMetadataProvider permissionMetadataProvider;
    private final List<RequestMatcher> allowInner = new ArrayList<RequestMatcher>(16);
    private final List<RequestMatcher> rejectInner = new ArrayList<RequestMatcher>(16);
    private HandlerMappingIntrospector handlerMappingIntrospector = new HandlerMappingIntrospector();
    private final Cache<String, Collection<ConfigAttribute>> requestPermissionCache;
    private final Cache<String, List<SysApiPermissionMetadataDTO>> tenantPermissionRoleCache;

    public CloudtFilterInvocationSecurityMetadataSource(AuthorizationProperties authorizationProperties, CustomSecurityProperties securityProperties, PermissionMetadataProvider permissionMetadataProvider, HandlerMappingIntrospector handlerMappingIntrospector) {
        this.authorizationProperties = authorizationProperties;
        this.securityProperties = securityProperties;
        this.permissionMetadataProvider = permissionMetadataProvider;
        if (handlerMappingIntrospector != null) {
            this.handlerMappingIntrospector = handlerMappingIntrospector;
        }
        this.requestPermissionCache = Caffeine.newBuilder().maximumSize(500L).expireAfterWrite(securityProperties.getLocalCachedTime()).build();
        this.tenantPermissionRoleCache = Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(securityProperties.getLocalCachedTime()).build();
        this.init();
    }

    public Collection<ConfigAttribute> getAttributes(Object object) throws IllegalArgumentException {
        HttpServletRequest request = ((FilterInvocation)object).getRequest();
        if (this.ignore(request)) {
            return SecurityConfig.createList((String[])new String[0]);
        }
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        if (currentUser == null) {
            return this.decline();
        }
        if (currentUser.isSystemAdmin()) {
            return SecurityConfig.createList((String[])new String[0]);
        }
        String cacheKey = this.generateCacheKey(currentUser) + ":" + request.getMethod() + ":" + request.getRequestURI();
        Collection<ConfigAttribute> configAttributes = (Collection<ConfigAttribute>)this.requestPermissionCache.getIfPresent((Object)cacheKey);
        if (configAttributes == null) {
            configAttributes = this.queryAttribute(currentUser, request);
            this.requestPermissionCache.put((Object)cacheKey, configAttributes);
        }
        if (configAttributes.isEmpty() && !this.securityProperties.isAllowOnNoMetadata()) {
            if (logger.isDebugEnabled()) {
                logger.debug("\u63a5\u53e3\u672a\u914d\u7f6e\u6743\u9650\uff1a{}", (Object)request.getRequestURI());
            }
            return this.decline();
        }
        return configAttributes;
    }

    public Collection<ConfigAttribute> getAllConfigAttributes() {
        return null;
    }

    public boolean supports(Class<?> clazz) {
        return FilterInvocation.class.isAssignableFrom(clazz);
    }

    public void setHandlerMappingIntrospector(HandlerMappingIntrospector handlerMappingIntrospector) {
        if (handlerMappingIntrospector == null) {
            return;
        }
        this.handlerMappingIntrospector = handlerMappingIntrospector;
    }

    public void init() {
        Set rejectUris;
        Set allowUris = InterceptUri.getAllowUri();
        if (!allowUris.isEmpty()) {
            for (String uri : allowUris) {
                this.allowInner.add(this.buildRequestMatcher(uri, null));
            }
        }
        if (!(rejectUris = InterceptUri.getRejectUri()).isEmpty()) {
            for (String uri : rejectUris) {
                this.rejectInner.add(this.buildRequestMatcher(uri, null));
            }
        }
    }

    protected boolean ignore(HttpServletRequest request) {
        if (!this.securityProperties.getPermissionEnabled()) {
            logger.debug("\u63a5\u53e3\u6743\u9650\u6821\u9a8c\u5df2\u7981\u7528");
            return true;
        }
        if (Boolean.TRUE.equals(this.authorizationProperties.getAnonymousEnabled())) {
            for (RequestMatcher requestMatcher : this.rejectInner) {
                if (!requestMatcher.matches(request)) continue;
                logger.debug("\u9ed1\u540d\u5355\u63a5\u53e3\uff0c\u9700\u8981\u63a5\u53e3\u6743\u9650\u6821\u9a8c");
                return false;
            }
            if (CollUtil.isNotEmpty((Collection)this.authorizationProperties.getRejectList())) {
                for (String uri : this.authorizationProperties.getRejectList()) {
                    RequestMatcher requestMatcher = this.buildRequestMatcher(uri, null);
                    if (!requestMatcher.matches(request)) continue;
                    logger.debug("\u9ed1\u540d\u5355\u63a5\u53e3\uff0c\u9700\u8981\u63a5\u53e3\u6743\u9650\u6821\u9a8c");
                    return false;
                }
            }
            logger.debug("\u5141\u8bb8\u533f\u540d\u8bbf\u95ee\uff0c\u5ffd\u7565\u63a5\u53e3\u6743\u9650\u6821\u9a8c");
            return true;
        }
        for (RequestMatcher requestMatcher : this.allowInner) {
            if (!requestMatcher.matches(request)) continue;
            logger.debug("\u767d\u540d\u5355\u63a5\u53e3\uff0c\u5ffd\u7565\u63a5\u53e3\u6743\u9650\u6821\u9a8c");
            return true;
        }
        if (CollUtil.isNotEmpty((Collection)this.authorizationProperties.getAllowList())) {
            for (String uri : this.authorizationProperties.getAllowList()) {
                RequestMatcher requestMatcher = this.buildRequestMatcher(uri, null);
                if (!requestMatcher.matches(request)) continue;
                logger.debug("\u767d\u540d\u5355\u63a5\u53e3\uff0c\u5ffd\u7565\u63a5\u53e3\u6743\u9650\u6821\u9a8c");
                return true;
            }
        }
        return false;
    }

    protected RequestMatcher buildRequestMatcher(@NotBlank String uri, String httpMethod) {
        if (this.authorizationProperties.getRequestMatcherType() == AuthorizationProperties.RequestMatcherType.MVC) {
            return new MvcRequestMatcher(this.handlerMappingIntrospector, uri);
        }
        return new AntPathRequestMatcher(uri, httpMethod);
    }

    protected Set<String> obtainFilterAppCodes() {
        if (CollUtil.isEmpty(this.securityProperties.getFilterAppCodes())) {
            return Set.of(CloudtAppHolder.getAppCode());
        }
        return this.securityProperties.getFilterAppCodes().contains("*") ? Collections.emptySet() : this.securityProperties.getFilterAppCodes();
    }

    protected Collection<ConfigAttribute> queryAttribute(GeneralUserDetails currentUser, HttpServletRequest request) {
        List<SysApiPermissionMetadataDTO> permissions = this.queryPermissionMetadata(currentUser);
        if (permissions.isEmpty()) {
            return Collections.emptyList();
        }
        return permissions.parallelStream().filter(t -> {
            if (!StringUtils.hasText((String)t.getUri())) {
                return false;
            }
            RequestMatcher matcher = this.buildRequestMatcher(t.getUri(), t.getMethod());
            return matcher.matches(request);
        }).flatMap(t -> {
            if (CollectionUtils.isEmpty((Collection)t.getRoleCodes())) {
                return Stream.of(this.authorizationProperties.getRolePrefix() + InnerRole.DENIED.getValue());
            }
            return t.getRoleCodes().stream().map(tt -> this.authorizationProperties.getRolePrefix() + tt);
        }).map(SecurityConfig::new).collect(Collectors.toSet());
    }

    private List<SysApiPermissionMetadataDTO> queryPermissionMetadata(GeneralUserDetails currentUser) {
        String cacheKey = this.generateCacheKey(currentUser);
        List<Object> permissions = (List<SysApiPermissionMetadataDTO>)this.tenantPermissionRoleCache.getIfPresent((Object)cacheKey);
        if (permissions != null) {
            return permissions;
        }
        Set<String> appCodes = this.obtainFilterAppCodes();
        permissions = this.permissionMetadataProvider.queryPermissionMetadata(currentUser, appCodes);
        if (permissions == null) {
            permissions = Collections.emptyList();
        }
        this.tenantPermissionRoleCache.put((Object)cacheKey, permissions);
        return permissions;
    }

    private Collection<ConfigAttribute> decline() {
        return SecurityConfig.createList((String[])new String[]{this.authorizationProperties.getRolePrefix() + InnerRole.DENIED.getValue()});
    }

    private String generateCacheKey(GeneralUserDetails currentUser) {
        String key = "default";
        if (currentUser != null && currentUser.getTenant() != null) {
            key = currentUser.getTenant().getTenantCode();
        }
        return key;
    }
}

