/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.swagger.openapi.model;

import com.elitescloud.boot.common.annotation.BusinessObject;
import com.elitescloud.boot.swagger.openapi.model.BusinessObjectParamInfo;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BusinessObjectInfo
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(BusinessObjectInfo.class);
    private static final long serialVersionUID = -465990391527734355L;
    private Boolean enabled;
    private String businessType;
    private String businessDescription;
    private String domain;
    private List<BusinessObjectParamInfo> paramInfoList;
    private String[] refBusinessObjectOperations;
    private Boolean publicResource;
    private Boolean supportTenant;

    public static BusinessObjectInfo getBusinessObjectInfo(BusinessObject businessObject) {
        BusinessObjectInfo businessObjectInfo = new BusinessObjectInfo();
        businessObjectInfo.setEnabled(businessObject.enabled());
        businessObjectInfo.setBusinessType(businessObject.businessType());
        businessObjectInfo.setBusinessDescription(businessObject.businessDescription());
        businessObjectInfo.setDomain(businessObject.businessObjectDomain());
        businessObjectInfo.setRefBusinessObjectOperations(businessObject.refBusinessObjectOperations());
        businessObjectInfo.setPublicResource(businessObject.publicResource());
        businessObjectInfo.setSupportTenant(businessObject.supportTenant());
        return businessObjectInfo;
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public String getBusinessType() {
        return this.businessType;
    }

    public String getBusinessDescription() {
        return this.businessDescription;
    }

    public String getDomain() {
        return this.domain;
    }

    public List<BusinessObjectParamInfo> getParamInfoList() {
        return this.paramInfoList;
    }

    public String[] getRefBusinessObjectOperations() {
        return this.refBusinessObjectOperations;
    }

    public Boolean getPublicResource() {
        return this.publicResource;
    }

    public Boolean getSupportTenant() {
        return this.supportTenant;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public void setBusinessType(String businessType) {
        this.businessType = businessType;
    }

    public void setBusinessDescription(String businessDescription) {
        this.businessDescription = businessDescription;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public void setParamInfoList(List<BusinessObjectParamInfo> paramInfoList) {
        this.paramInfoList = paramInfoList;
    }

    public void setRefBusinessObjectOperations(String[] refBusinessObjectOperations) {
        this.refBusinessObjectOperations = refBusinessObjectOperations;
    }

    public void setPublicResource(Boolean publicResource) {
        this.publicResource = publicResource;
    }

    public void setSupportTenant(Boolean supportTenant) {
        this.supportTenant = supportTenant;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BusinessObjectInfo)) {
            return false;
        }
        BusinessObjectInfo other = (BusinessObjectInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$enabled = this.getEnabled();
        Boolean other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !((Object)this$enabled).equals(other$enabled)) {
            return false;
        }
        Boolean this$publicResource = this.getPublicResource();
        Boolean other$publicResource = other.getPublicResource();
        if (this$publicResource == null ? other$publicResource != null : !((Object)this$publicResource).equals(other$publicResource)) {
            return false;
        }
        Boolean this$supportTenant = this.getSupportTenant();
        Boolean other$supportTenant = other.getSupportTenant();
        if (this$supportTenant == null ? other$supportTenant != null : !((Object)this$supportTenant).equals(other$supportTenant)) {
            return false;
        }
        String this$businessType = this.getBusinessType();
        String other$businessType = other.getBusinessType();
        if (this$businessType == null ? other$businessType != null : !this$businessType.equals(other$businessType)) {
            return false;
        }
        String this$businessDescription = this.getBusinessDescription();
        String other$businessDescription = other.getBusinessDescription();
        if (this$businessDescription == null ? other$businessDescription != null : !this$businessDescription.equals(other$businessDescription)) {
            return false;
        }
        String this$domain = this.getDomain();
        String other$domain = other.getDomain();
        if (this$domain == null ? other$domain != null : !this$domain.equals(other$domain)) {
            return false;
        }
        List<BusinessObjectParamInfo> this$paramInfoList = this.getParamInfoList();
        List<BusinessObjectParamInfo> other$paramInfoList = other.getParamInfoList();
        if (this$paramInfoList == null ? other$paramInfoList != null : !((Object)this$paramInfoList).equals(other$paramInfoList)) {
            return false;
        }
        return Arrays.deepEquals(this.getRefBusinessObjectOperations(), other.getRefBusinessObjectOperations());
    }

    protected boolean canEqual(Object other) {
        return other instanceof BusinessObjectInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $enabled = this.getEnabled();
        result = result * 59 + ($enabled == null ? 43 : ((Object)$enabled).hashCode());
        Boolean $publicResource = this.getPublicResource();
        result = result * 59 + ($publicResource == null ? 43 : ((Object)$publicResource).hashCode());
        Boolean $supportTenant = this.getSupportTenant();
        result = result * 59 + ($supportTenant == null ? 43 : ((Object)$supportTenant).hashCode());
        String $businessType = this.getBusinessType();
        result = result * 59 + ($businessType == null ? 43 : $businessType.hashCode());
        String $businessDescription = this.getBusinessDescription();
        result = result * 59 + ($businessDescription == null ? 43 : $businessDescription.hashCode());
        String $domain = this.getDomain();
        result = result * 59 + ($domain == null ? 43 : $domain.hashCode());
        List<BusinessObjectParamInfo> $paramInfoList = this.getParamInfoList();
        result = result * 59 + ($paramInfoList == null ? 43 : ((Object)$paramInfoList).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getRefBusinessObjectOperations());
        return result;
    }

    public String toString() {
        return "BusinessObjectInfo(enabled=" + this.getEnabled() + ", businessType=" + this.getBusinessType() + ", businessDescription=" + this.getBusinessDescription() + ", domain=" + this.getDomain() + ", paramInfoList=" + this.getParamInfoList() + ", refBusinessObjectOperations=" + Arrays.deepToString(this.getRefBusinessObjectOperations()) + ", publicResource=" + this.getPublicResource() + ", supportTenant=" + this.getSupportTenant() + ")";
    }
}

