/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.datasources;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.baomidou.dynamic.datasource.toolkit.DynamicDataSourceContextHolder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.boot.tenant.datasources.SpringDatasourceDynamicTenantProperties;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.servlet.HandlerInterceptor;

public class WebInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(WebInterceptor.class);
    private DataSource dataSource;
    private SpringDatasourceDynamicTenantProperties datasourceProperties;

    public WebInterceptor(SpringDatasourceDynamicTenantProperties datasourceProperties, DataSource dataSource) {
        this.dataSource = dataSource;
        this.datasourceProperties = datasourceProperties;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user == null) {
            log.error("\u7ebf\u7a0b\u5207\u6362\u79df\u6237\u6570\u636e\u6e90\u5931\u8d25\uff1a\u65e0\u6cd5\u83b7\u53d6\u5f53\u524d\u7528\u6237\u4fe1\u606f," + SecurityContextUtil.currentToken());
            throw new BusinessException(ApiCode.UNAUTHORIZED, "\u8bf7\u5148\u767b\u5f55");
        }
        SysTenantDTO tenant = user.getUser().getSysTenantVO();
        if (tenant != null) {
            String tenantCode = tenant.getTenantCode();
            String dsDataSourceName = this.datasourceProperties.getAppName() + "_" + tenantCode;
            DynamicRoutingDataSource ds = (DynamicRoutingDataSource)this.dataSource;
            Map mapDs = ds.getDataSources();
            if (tenant.getId() == -1L) {
                log.info("\u6570\u636e\u6e90\u4f7f\u7528\u5171\u4eab\u4e3b\u5e93\uff0c\u4e0d\u4f7f\u7528\u79df\u6237\u670d\u52a1\u6570\u636e\u6e90\u5e93\uff1atenantID={}", (Object)tenant.getId());
            } else {
                log.info("\u5f00\u59cb\u4f7f\u7528\u79df\u6237\u670d\u52a1\u6570\u636e\u6e90\u5e93\uff1atenantID={}", (Object)tenant.getId());
                if (mapDs.containsKey(dsDataSourceName)) {
                    DynamicDataSourceContextHolder.push((String)dsDataSourceName);
                    log.info("\u7ebf\u7a0b\u5207\u6362\u79df\u6237\u6570\u636e\u6e90\u5230\uff1a{}", (Object)dsDataSourceName);
                } else {
                    log.error("\u4e0d\u5b58\u5728\u79df\u6237\u6570\u636e\u6e90\uff0c\u7ebf\u7a0b\u5207\u6362\u79df\u6237\u6570\u636e\u6e90\u5931\u8d25\uff1a{}", (Object)dsDataSourceName);
                    throw new BusinessException(ApiCode.UNAUTHORIZED, "\u8bf7\u5148\u767b\u5f55");
                }
            }
            return true;
        }
        log.error("\u7ebf\u7a0b\u5207\u6362\u79df\u6237\u6570\u636e\u6e90\u8df3\u8fc7\uff1a\u6ca1\u6709\u5f53\u524d\u7528\u6237\u79df\u6237\u4fe1\u606f\uff0c{}", (Object)user.getUser());
        throw new BusinessException(ApiCode.UNAUTHORIZED, "\u8bf7\u5148\u767b\u5f55");
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        DynamicDataSourceContextHolder.clear();
    }
}

