/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.common;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.tenant.client.TenantClientProperties;
import com.elitescloud.boot.tenant.client.common.TenantProvider;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.common.common.CloudtOptional;
import com.elitescloud.cloudt.context.util.HttpServletUtil;
import com.elitescloud.cloudt.context.util.ValidateUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;

public class TenantRequestUtil {
    private static final Logger log = LogManager.getLogger(TenantRequestUtil.class);
    private static TenantClientProperties clientProperties;
    private static TenantProvider tenantProvider;
    private static RedisWrapper tenantRedisWrapper;

    protected TenantRequestUtil() {
    }

    public static String obtainTenantDomain(HttpServletRequest request) {
        String url = HttpServletUtil.obtainDomain((HttpServletRequest)request);
        String defaultDomain = TenantRequestUtil.getClientProperties().getTenantDomain();
        if (StringUtils.hasText((String)defaultDomain)) {
            url = TenantRequestUtil.filterChildDomain(url, defaultDomain);
        }
        if (ValidateUtil.isIp((String)url)) {
            return null;
        }
        return url;
    }

    public static SysTenantDTO obtainTenant(HttpServletRequest request) {
        GeneralUserDetails user = SecurityContextUtil.currentUser();
        if (user != null && user.getTenant() != null) {
            return user.getTenant();
        }
        try {
            return (SysTenantDTO)TenantRequestUtil.getTenantRedisWrapper().apply(() -> {
                String domain;
                String tenantId = request.getHeader("X-Tenant-Id");
                if (StringUtils.hasText((String)tenantId)) {
                    if (TenantConstant.DEFAULT_TENANT_ID.toString().equals(tenantId)) {
                        return null;
                    }
                    CloudtOptional<SysTenantDTO> tenant = TenantRequestUtil.getTenantProvider().getById(Long.parseLong(tenantId));
                    return tenant.orElseThrow();
                }
                String tenantCode = request.getHeader("X-Tenant-Code");
                if (StringUtils.hasText((String)tenantCode)) {
                    if (TenantConstant.DEFAULT_TENANT_ID.toString().equals(tenantId)) {
                        return null;
                    }
                    CloudtOptional<SysTenantDTO> tenant = TenantRequestUtil.getTenantProvider().getByCode(tenantCode);
                    return tenant.orElseThrow();
                }
                if (StringUtils.hasText((String)TenantRequestUtil.getClientProperties().getTenantDomain()) && StringUtils.hasText((String)(domain = TenantRequestUtil.obtainTenantDomain(request)))) {
                    CloudtOptional<SysTenantDTO> tenant = TenantRequestUtil.getTenantProvider().getByDomain(domain);
                    if (tenant.isPresent()) {
                        log.debug("\u8bf7\u6c42\u3010{}\u3011\u89e3\u6790\u5f97\u79df\u6237\uff1a{}", (Object)request.getRequestURL().toString(), (Object)((SysTenantDTO)tenant.get()).getTenantName());
                        return tenant.get();
                    }
                    log.debug("\u8bf7\u6c42\u3010{}\u3011\u89e3\u6790\u5f97\u57df\u540d\u3010{}\u3011\u672a\u67e5\u8be2\u5230\u79df\u6237\u4fe1\u606f", (Object)request.getRequestURL().toString(), (Object)domain);
                }
                return null;
            }, null);
        }
        catch (Exception e) {
            throw ExceptionsUtil.normalize((Throwable)e, (String)"\u83b7\u53d6\u5f53\u524d\u79df\u6237\u5931\u8d25");
        }
    }

    public static TenantClientProperties getClientProperties() {
        if (clientProperties == null) {
            clientProperties = (TenantClientProperties)SpringContextHolder.getBean(TenantClientProperties.class);
        }
        return clientProperties;
    }

    public static TenantProvider getTenantProvider() {
        if (tenantProvider == null) {
            tenantProvider = (TenantProvider)SpringContextHolder.getBean(TenantProvider.class);
        }
        return tenantProvider;
    }

    public static RedisWrapper getTenantRedisWrapper() {
        if (tenantRedisWrapper == null) {
            tenantRedisWrapper = (RedisWrapper)SpringContextHolder.getBean(RedisWrapper.class);
        }
        return tenantRedisWrapper;
    }

    private static String filterChildDomain(String domain, String defaultDomain) {
        if (domain == null) {
            return null;
        }
        if (domain.endsWith(defaultDomain)) {
            int end = domain.length() - defaultDomain.length() - 1;
            if (end <= 0) {
                return domain;
            }
            return domain.substring(0, end);
        }
        return domain;
    }
}

