/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.impl;

import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.wrapper.TransactionWrapper;
import com.elitescloud.cloudt.core.tenant.support.TenantDataIsolateProvider;
import com.elitescloud.cloudt.system.constant.TenantType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultTenantDataIsolateProvider
implements TenantDataIsolateProvider {
    private static final Logger log = LogManager.getLogger(DefaultTenantDataIsolateProvider.class);
    private final TransactionWrapper transactionWrapper;
    private final TenantClientProvider tenantClientProvider;

    public DefaultTenantDataIsolateProvider(TransactionWrapper transactionWrapper, TenantClientProvider tenantClientProvider) {
        this.transactionWrapper = transactionWrapper;
        this.tenantClientProvider = tenantClientProvider;
    }

    public <T> T byNone(Supplier<T> supplier) {
        return (T)this.transactionWrapper.apply(supplier, (Object)"ISOLATABLE_NONE");
    }

    public <T> T byDefaultDirectly(Supplier<T> supplier) {
        return (T)this.transactionWrapper.apply(supplier, null);
    }

    public <T> T byTenantDirectly(Supplier<T> supplier, SysTenantDTO tenantDTO) {
        return (T)this.transactionWrapper.apply(supplier, (Object)tenantDTO);
    }

    public <T> T byTenantUser(Supplier<T> supplier, SysUserDTO currentUser) {
        if (currentUser.getSysTenantVO() != null && currentUser.getSysTenantVO().getSysUserId().longValue() != currentUser.getId().longValue() && currentUser.getSysTenantVO().getType() != TenantType.OPERATION) {
            return (T)this.transactionWrapper.apply(supplier, (Object)currentUser);
        }
        return (T)this.transactionWrapper.apply(supplier, null);
    }

    public <T> T byTenant(Supplier<T> supplier, SysUserDTO currentUser) {
        if (currentUser.getSysTenantVO() != null && currentUser.getSysTenantVO().getType() != TenantType.OPERATION) {
            return (T)this.transactionWrapper.apply(supplier, (Object)currentUser);
        }
        return (T)this.transactionWrapper.apply(supplier, null);
    }

    public <T> T byTenantAuto(Supplier<T> supplier) {
        SysTenantDTO tenant = this.tenantClientProvider.getCurrentTenant();
        if (tenant != null && tenant.getType() != TenantType.OPERATION) {
            return (T)this.transactionWrapper.apply(supplier, (Object)tenant);
        }
        return (T)this.transactionWrapper.apply(supplier, null);
    }

    public <T> void byAllTenant(Supplier<T> supplier) {
        List<SysTenantDTO> tenants = this.getAllTenant();
        for (SysTenantDTO tenant : tenants) {
            try {
                this.transactionWrapper.apply(supplier, (Object)tenant);
            }
            catch (Exception e) {
                log.error("\u5904\u7406\u79df\u6237\u3010" + tenant.getId() + "\u3011\u76f8\u5173\u4e1a\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            }
        }
        try {
            this.transactionWrapper.apply(supplier, null);
        }
        catch (Exception e) {
            log.error("\u5904\u7406\u9ed8\u8ba4\u79df\u6237\u76f8\u5173\u4e1a\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
        }
    }

    private List<SysTenantDTO> getAllTenant() {
        return this.tenantClientProvider.getAllTenants();
    }

    private SysTenantDTO getTenant(Long sysTenantId) {
        return this.tenantClientProvider.getTenant(sysTenantId);
    }
}

