/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.redis.CloudtRedisAutoConfiguration;
import com.elitescloud.boot.redis.common.support.RedisKeyPrefix;
import com.elitescloud.boot.tenant.client.TenantClientProperties;
import com.elitescloud.boot.tenant.client.support.config.TenantRedisWrapper;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.context.annotation.Bean;

@ConditionalOnTenant
@AutoConfigureBefore(value={CloudtRedisAutoConfiguration.class})
class CloudtTenantRedisAutoConfiguration {
    CloudtTenantRedisAutoConfiguration() {
    }

    @Bean(value={"tenantRedisWrapper"})
    public RedisWrapper tenantRedisWrapper() {
        return new TenantRedisWrapper();
    }

    @Bean
    public RedisKeyPrefix tenantRedisKeyPrefix(TenantClientProperties clientProperties) {
        return () -> {
            if (!clientProperties.isRedisSeparate()) {
                return "tenant_default";
            }
            if (TenantSession.getUseDefault() || TenantSession.getNoTenant()) {
                return clientProperties.getDefaultRedisKeyPrefix();
            }
            SysTenantDTO tenant = TenantSession.getCurrentTenant();
            if (tenant == null) {
                tenant = TenantContextHolder.getCurrentTenant();
            }
            if (tenant == null) {
                return clientProperties.getDefaultRedisKeyPrefix();
            }
            return "tenant_" + tenant.getTenantCode();
        };
    }
}

