/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.common;

import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.boot.wrapper.BaseCallbackWrapper;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.constant.TenantType;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.system.vo.SysUserDTO;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractTenantIsolateDelegate<T, R, E>
implements BaseCallbackWrapper<T, R> {
    private static final Logger log = LogManager.getLogger(AbstractTenantIsolateDelegate.class);

    protected abstract boolean supportApply(SysTenantDTO var1);

    protected abstract E beforeApply(Supplier<R> var1, SysTenantDTO var2);

    protected abstract void afterCompletion(R var1, E var2, boolean var3, Exception var4);

    public R apply(Supplier<R> supplier, T param) {
        if ("ISOLATABLE_NONE".equals(param)) {
            return this.applyNot(supplier);
        }
        SysTenantDTO tenant = this.convertSubject(param);
        if (!this.supportApply(tenant)) {
            return supplier.get();
        }
        if (tenant == null || tenant.getType() == TenantType.OPERATION) {
            return this.applyDefault(supplier, false);
        }
        return this.applyTenant(supplier, tenant);
    }

    private SysTenantDTO convertSubject(T subject) {
        if (subject == null) {
            return null;
        }
        if (subject instanceof SysTenantDTO) {
            return (SysTenantDTO)subject;
        }
        if (subject instanceof GeneralUserDetails) {
            GeneralUserDetails user = (GeneralUserDetails)subject;
            return user.getTenant();
        }
        if (subject instanceof SysUserDTO) {
            SysUserDTO user = (SysUserDTO)subject;
            return user.getSysTenantVO();
        }
        if (subject instanceof Long) {
            return TenantClient.getTenant((Long)subject);
        }
        if (subject instanceof String) {
            return TenantClient.getTenant(Long.parseLong((String)subject));
        }
        throw new IllegalArgumentException("\u672a\u77e5\u53c2\u6570\u4e3b\u4f53\u7c7b\u578b");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R applyNot(Supplier<R> supplier) {
        boolean hasNot = TenantSession.getNoTenant();
        if (hasNot) {
            return supplier.get();
        }
        TenantSession.setNoTenant();
        try {
            R r = this.applyDefault(supplier, true);
            return r;
        }
        finally {
            TenantSession.clearNoTenant();
        }
    }

    private R applyDefault(Supplier<R> supplier, boolean forNot) {
        boolean hasDefault = TenantSession.getUseDefault();
        if (hasDefault && !forNot) {
            return supplier.get();
        }
        if (!forNot) {
            TenantSession.setUseDefault();
        }
        E customParam = null;
        try {
            customParam = this.beforeApply(supplier, null);
            R result = supplier.get();
            this.executeCompletion(result, customParam, true, null);
            R r = result;
            return r;
        }
        catch (Exception e) {
            this.executeCompletion(null, customParam, true, e);
            throw e;
        }
        finally {
            if (!forNot) {
                TenantSession.clearUseDefault();
            }
        }
    }

    private R applyTenant(Supplier<R> supplier, SysTenantDTO tenant) {
        SysTenantDTO currentTenant;
        boolean hasUsedDefault;
        boolean hasNot = TenantSession.getNoTenant();
        if (hasNot) {
            TenantSession.clearNoTenant();
        }
        if (hasUsedDefault = TenantSession.getUseDefault()) {
            TenantSession.clearUseDefault();
        }
        if (!hasNot && !hasUsedDefault && (currentTenant = TenantClient.getSessionTenant()) != null && currentTenant.getId().longValue() == tenant.getId().longValue()) {
            return supplier.get();
        }
        SysTenantDTO hasUsedTenant = TenantSession.getCurrentTenant();
        TenantSession.setCurrentTenant((SysTenantDTO)tenant);
        E customParam = null;
        try {
            customParam = this.beforeApply(supplier, tenant);
            R result = supplier.get();
            this.executeCompletion(result, customParam, false, null);
            R r = result;
            return r;
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u5f02\u5e38\uff1a", (Throwable)e);
            this.executeCompletion(null, customParam, false, e);
            throw e;
        }
        finally {
            if (hasUsedTenant == null) {
                TenantSession.clearCurrentTenant();
            } else {
                TenantSession.setCurrentTenant((SysTenantDTO)hasUsedTenant);
            }
            if (hasUsedDefault) {
                TenantSession.setUseDefault();
            }
            if (hasNot) {
                TenantSession.setNoTenant();
            }
        }
    }

    private void executeCompletion(R result, E customParam, boolean useDefault, Exception exp) {
        this.afterCompletion(result, customParam, useDefault, exp);
    }
}

