/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.config;

import com.elitescloud.boot.provider.TenantOrgDataIsolateProvider;
import com.elitescloud.boot.util.ExceptionsUtil;
import com.elitescloud.cloudt.core.annotation.TenantOrgTransaction;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.aop.aspectj.MethodInvocationProceedingJoinPoint;
import org.springframework.util.Assert;

@Aspect
public class TenantOrgTransactionAspect {
    private final TenantOrgDataIsolateProvider tenantOrgDataIsolateProvider;

    public TenantOrgTransactionAspect(TenantOrgDataIsolateProvider tenantOrgDataIsolateProvider) {
        this.tenantOrgDataIsolateProvider = tenantOrgDataIsolateProvider;
    }

    @Pointcut(value="@annotation(com.elitescloud.cloudt.core.annotation.TenantOrgTransaction)")
    private void pointCutMethod() {
    }

    @Pointcut(value="@within(com.elitescloud.cloudt.core.annotation.TenantOrgTransaction)")
    private void pointCutClass() {
    }

    @Around(value="pointCutClass() || pointCutMethod()")
    public Object cutAround(ProceedingJoinPoint point) throws Throwable {
        TenantOrgTransaction annotation = this.obtainAnnotation(point);
        Assert.notNull((Object)annotation, (String)"\u672a\u83b7\u53d6\u5230TenantOrgTransaction\u6ce8\u89e3\u4fe1\u606f");
        boolean isUseTenantOrg = annotation.useTenantOrg();
        if (isUseTenantOrg) {
            return this.tenantOrgDataIsolateProvider.byCurrentTenantOrg(() -> {
                try {
                    return point.proceed();
                }
                catch (Throwable e) {
                    throw ExceptionsUtil.wrapRuntime((Throwable)e);
                }
            });
        }
        return this.tenantOrgDataIsolateProvider.byNoTenantOrg(() -> {
            try {
                return point.proceed();
            }
            catch (Throwable e) {
                throw ExceptionsUtil.wrapRuntime((Throwable)e);
            }
        });
    }

    private TenantOrgTransaction obtainAnnotation(ProceedingJoinPoint point) {
        if (point instanceof MethodInvocationProceedingJoinPoint) {
            TenantOrgTransaction annotation = ((MethodSignature)point.getSignature()).getMethod().getAnnotation(TenantOrgTransaction.class);
            if (annotation == null) {
                annotation = point.getThis().getClass().getAnnotation(TenantOrgTransaction.class);
            }
            return annotation;
        }
        return null;
    }
}

