package com.elitescloud.boot.tenant.client.common;

import com.elitescloud.cloudt.common.common.CloudtOptional;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;

import java.util.Map;

/**
 * 租户信息提供者.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/26
 */
public interface TenantProvider {

    /**
     * 获取所有租户信息
     *
     * @return 租户信息
     */
    Map<String, SysTenantDTO> getAllTenant();

    /**
     * 根据租户ID获取租户信息
     *
     * @param id 租户ID
     * @return 租户信息
     */
    CloudtOptional<SysTenantDTO> getById(Long id);

    /**
     * 根据租户编码获取租户信息
     *
     * @param code 租户编码
     * @return 租户信息
     */
    CloudtOptional<SysTenantDTO> getByCode(String code);

    /**
     * 根据域名获取租户信息
     *
     * @param domain 域名
     * @return 租户信息
     */
    CloudtOptional<SysTenantDTO> getByDomain(String domain);

    /**
     * 清理缓存
     */
    default void clearCache() {
    }
}
