/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.common;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.auth.util.SecurityContextUtil;
import com.elitescloud.boot.context.TenantContextHolder;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.tenant.client.common.TenantProvider;
import com.elitescloud.boot.tenant.client.common.TenantRequestUtil;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class TenantClient {
    private static final Logger log = LogManager.getLogger(TenantClient.class);
    private static TenantProvider tenantProvider;
    private static final AtomicBoolean INITED;

    protected TenantClient() {
    }

    public static boolean enabledTenant() {
        return TenantContextHolder.isEnabledTenant();
    }

    public static SysTenantDTO getCurrentTenant() {
        if (!TenantClient.enabledTenant()) {
            return null;
        }
        return TenantClient.obtainTenant();
    }

    public static SysTenantDTO getSessionTenant() {
        if (!TenantClient.enabledTenant()) {
            return null;
        }
        if (TenantSession.getUseDefault() || TenantSession.getNoTenant()) {
            return null;
        }
        return (SysTenantDTO)ObjectUtil.defaultIfNull((Object)TenantSession.getCurrentTenant(), (Object)TenantClient.getCurrentTenant());
    }

    public static SysTenantDTO getTenant(Long tenantId) {
        if (!TenantClient.enabledTenant()) {
            return null;
        }
        if (tenantId == null) {
            return null;
        }
        return (SysTenantDTO)TenantClient.getTenantProvider().getById(tenantId).get();
    }

    public static SysTenantDTO getTenant(String code) {
        if (!TenantClient.enabledTenant()) {
            return null;
        }
        if (!StringUtils.hasText((String)code)) {
            return null;
        }
        return (SysTenantDTO)TenantClient.getTenantProvider().getByCode(code).get();
    }

    public static List<SysTenantDTO> getAllTenants() {
        if (!TenantClient.enabledTenant()) {
            return Collections.emptyList();
        }
        return new ArrayList<SysTenantDTO>(TenantClient.getTenantProvider().getAllTenant().values());
    }

    public static SysTenantDTO obtainTenantFromRequest() {
        if (!TenantClient.enabledTenant()) {
            return null;
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes == null) {
            return null;
        }
        return TenantRequestUtil.obtainTenant(((ServletRequestAttributes)requestAttributes).getRequest());
    }

    public static void clearCache() {
        if (!TenantClient.enabledTenant()) {
            return;
        }
        TenantClient.getTenantProvider().clearCache();
    }

    private static TenantProvider getTenantProvider() {
        if (INITED.compareAndSet(false, true)) {
            tenantProvider = (TenantProvider)SpringContextHolder.getObjectProvider(TenantProvider.class).getIfAvailable();
        }
        return tenantProvider;
    }

    private static SysTenantDTO obtainTenant() {
        SysTenantDTO tenant = TenantContextHolder.getCurrentTenant();
        if (tenant != null) {
            return tenant;
        }
        GeneralUserDetails currentUser = SecurityContextUtil.currentUser();
        if (currentUser != null && (tenant = currentUser.getTenant()) != null) {
            return tenant;
        }
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        if (requestAttributes != null) {
            return TenantRequestUtil.obtainTenant(((ServletRequestAttributes)requestAttributes).getRequest());
        }
        return null;
    }

    static {
        INITED = new AtomicBoolean(false);
    }
}

