/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.common;

import com.elitescloud.boot.tenant.client.common.TenantClient;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import javax.sql.DataSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.orm.jpa.vendor.Database;
import org.springframework.util.StringUtils;

public abstract class AbstractTenantDatasourceProvider {
    private static final Logger log = LogManager.getLogger(AbstractTenantDatasourceProvider.class);
    private static String defaultSchema;
    private static DataSource defaultDataSource;
    private static Database databaseType;
    private static TenantIsolateStrategy isolateStrategy;

    private AbstractTenantDatasourceProvider() {
    }

    public static SysTenantDTO detectedTenant() {
        return TenantClient.getSessionTenant();
    }

    public static String getDefaultSchema() {
        return defaultSchema;
    }

    public static void setDefaultSchema(String defaultSchema) {
        if (StringUtils.hasText((String)AbstractTenantDatasourceProvider.defaultSchema) || !StringUtils.hasText((String)defaultSchema)) {
            return;
        }
        AbstractTenantDatasourceProvider.defaultSchema = defaultSchema;
    }

    public static DataSource getDefaultDataSource() {
        return defaultDataSource;
    }

    public static void setDefaultDataSource(DataSource defaultDataSource) {
        if (defaultDataSource == null) {
            return;
        }
        AbstractTenantDatasourceProvider.defaultDataSource = defaultDataSource;
    }

    public static Database getDatabaseType() {
        return databaseType;
    }

    public static void setDatabaseType(Database databaseType) {
        if (databaseType == null || AbstractTenantDatasourceProvider.databaseType != null) {
            return;
        }
        AbstractTenantDatasourceProvider.databaseType = databaseType;
    }

    public static Database getDatabaseTypeByUrl(String url) {
        if (url == null) {
            return null;
        }
        int index = url.indexOf("://");
        if (index <= 0) {
            return null;
        }
        String temp = url.substring(0, index);
        index = temp.lastIndexOf(":");
        if (index > 0) {
            temp = temp.substring(index + 1);
        }
        try {
            return Database.valueOf((String)temp.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            log.error("\u89e3\u6790\u6570\u636e\u5e93\u7c7b\u578b\u5931\u8d25\uff1a{}", (Object)url);
            return null;
        }
    }

    public static void setIsolateStrategy(TenantIsolateStrategy isolateStrategy) {
        if (isolateStrategy == null) {
            return;
        }
        log.debug("\u79df\u6237\u9694\u79bb\u7b56\u7565\uff1a{}", (Object)isolateStrategy);
        AbstractTenantDatasourceProvider.isolateStrategy = isolateStrategy;
    }

    public static TenantIsolateStrategy getIsolateStrategy() {
        return isolateStrategy;
    }

    static {
        isolateStrategy = TenantIsolateStrategy.NONE;
    }
}

