/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.impl;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.constant.TenantConstant;
import com.elitescloud.boot.context.TenantSession;
import com.elitescloud.boot.redis.util.RedisUtils;
import com.elitescloud.boot.tenant.client.support.TenantProviderService;
import com.elitescloud.boot.wrapper.RedisWrapper;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.common.CloudtOptional;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import com.elitescloud.cloudt.tenant.provider.TenantProvider;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.springframework.util.Assert;

public class DefaultTenantProvider
implements TenantProvider {
    private static final Logger logger = CloudtBootLoggerFactory.TENANT.getLogger(DefaultTenantProvider.class);
    private final TenantProviderService tenantProviderService;
    private final RedisUtils redisUtils;
    private final RedisWrapper redisWrapper;
    private final Cache<String, SysTenantDTO> tenantCache;
    private Cache<String, Boolean> queryFail = null;
    private static final String FAIL_KEY_ALL = "all";

    public DefaultTenantProvider(TenantProviderService tenantProviderService, RedisUtils redisUtils, RedisWrapper redisWrapper) {
        this.tenantProviderService = tenantProviderService;
        this.redisUtils = redisUtils;
        this.redisWrapper = redisWrapper;
        this.tenantCache = Caffeine.newBuilder().maximumSize(400L).expireAfterWrite(Duration.ofMinutes(30L)).build();
        this.queryFail = Caffeine.newBuilder().maximumSize(20L).expireAfterWrite(Duration.ofMinutes(20L)).build();
    }

    @Override
    public Map<String, SysTenantDTO> getAllTenant() {
        List<SysTenantDTO> tenants = this.queryAllTenants();
        if (tenants.isEmpty()) {
            return Collections.emptyMap();
        }
        Map<String, SysTenantDTO> tenantMap = tenants.stream().collect(Collectors.toMap(t -> t.getId().toString(), t -> t, (t1, t2) -> t1));
        return Collections.unmodifiableMap(tenantMap);
    }

    @Override
    public CloudtOptional<SysTenantDTO> getById(Long id) {
        Assert.notNull((Object)id, (String)"\u79df\u6237ID\u4e3a\u7a7a");
        if (id.longValue() == TenantConstant.DEFAULT_TENANT_ID.longValue()) {
            return CloudtOptional.empty();
        }
        SysTenantDTO tenant = (SysTenantDTO)this.tenantCache.getIfPresent((Object)("id_" + id));
        if (tenant != null) {
            return CloudtOptional.of((Serializable)tenant);
        }
        List<SysTenantDTO> tenants = this.queryAllTenants();
        if (tenants.isEmpty()) {
            return CloudtOptional.empty();
        }
        tenant = tenants.stream().filter(t -> t.getId().equals(id)).findFirst().orElse(null);
        if (tenant != null) {
            this.tenantCache.put((Object)("id_" + id), (Object)tenant);
        }
        return CloudtOptional.of((Serializable)tenant);
    }

    @Override
    public CloudtOptional<SysTenantDTO> getByCode(String code) {
        Assert.hasText((String)code, (String)"\u79df\u6237\u7f16\u7801\u4e3a\u7a7a");
        SysTenantDTO tenant = (SysTenantDTO)this.tenantCache.getIfPresent((Object)("code_" + code));
        if (tenant != null) {
            return CloudtOptional.of((Serializable)tenant);
        }
        List<SysTenantDTO> tenants = this.queryAllTenants();
        if (tenants.isEmpty()) {
            return CloudtOptional.empty();
        }
        tenant = tenants.stream().filter(t -> code.equals(t.getTenantCode())).findFirst().orElse(null);
        if (tenant != null) {
            this.tenantCache.put((Object)("code_" + code), (Object)tenant);
        }
        return CloudtOptional.of((Serializable)tenant);
    }

    @Override
    public CloudtOptional<SysTenantDTO> getByDomain(String domain) {
        SysTenantDTO tenant = (SysTenantDTO)this.tenantCache.getIfPresent((Object)("domain_" + domain));
        if (tenant != null) {
            return CloudtOptional.of((Serializable)tenant);
        }
        List<SysTenantDTO> tenants = this.queryAllTenants();
        if (tenants.isEmpty()) {
            return CloudtOptional.empty();
        }
        tenant = tenants.stream().filter(t -> {
            if (CharSequenceUtil.equals((CharSequence)t.getTenantDomain(), (CharSequence)domain)) {
                return true;
            }
            return this.delimiterMatch(t.getCustomDomain(), domain);
        }).findFirst().orElse(null);
        if (tenant != null) {
            this.tenantCache.put((Object)("domain_" + domain), (Object)tenant);
        }
        return CloudtOptional.of((Serializable)tenant);
    }

    @Override
    public void clearCache() {
        this.tenantCache.invalidateAll();
        String cacheKey = "cloudt_tenant:all";
        this.redisWrapper.apply(() -> {
            this.redisUtils.del(new String[]{cacheKey});
            return null;
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<SysTenantDTO> queryAllFromServer() {
        if (this.queryFail.getIfPresent((Object)FAIL_KEY_ALL) != null) {
            return Collections.emptyList();
        }
        ApiResult<List<SysTenantDTO>> queryTenantResult = null;
        TenantSession.setNoTenant();
        try {
            queryTenantResult = this.tenantProviderService.allTenants();
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5f02\u5e38\uff1a", (Throwable)e);
            this.queryFail.put((Object)FAIL_KEY_ALL, (Object)true);
            List<SysTenantDTO> list = Collections.emptyList();
            return list;
        }
        finally {
            TenantSession.clearNoTenant();
        }
        if (!queryTenantResult.isSuccess() || queryTenantResult.getData() == null) {
            logger.error("\u67e5\u8be2\u79df\u6237\u4fe1\u606f\u5931\u8d25\uff1a{}", (Object)(queryTenantResult.getMsg() + "\uff1b" + queryTenantResult.getErrorMsg()));
            return Collections.emptyList();
        }
        if (((List)queryTenantResult.getData()).isEmpty()) {
            logger.warn("\u672a\u67e5\u8be2\u5230\u6709\u6548\u79df\u6237\u4fe1\u606f");
        }
        return (List)queryTenantResult.getData();
    }

    protected List<SysTenantDTO> queryAllFromRedis() {
        String cacheKey = "cloudt_tenant:all";
        Map redisAll = null;
        try {
            redisAll = (Map)this.redisWrapper.apply(() -> this.redisUtils.get(cacheKey), null);
        }
        catch (Exception e) {
            logger.error("\u67e5\u8be2\u79df\u6237\u7f13\u5b58\u5931\u8d25\uff1a", (Throwable)e);
        }
        if (redisAll != null) {
            return new ArrayList<SysTenantDTO>(redisAll.values());
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SysTenantDTO> queryAllTenants() {
        String string = FAIL_KEY_ALL;
        synchronized (FAIL_KEY_ALL) {
            List<SysTenantDTO> tenants = this.queryAllFromRedis();
            if (!tenants.isEmpty()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.unmodified(tenants);
            }
            tenants = this.queryAllFromServer();
            if (tenants.isEmpty()) {
                this.queryFail.put((Object)FAIL_KEY_ALL, (Object)true);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Collections.emptyList();
            }
            this.cacheToRedis(tenants);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.unmodified(tenants);
        }
    }

    private void cacheToRedis(List<SysTenantDTO> tenants) {
        String cacheKey = "cloudt_tenant:all";
        Map<String, SysTenantDTO> tenantMap = tenants.stream().collect(Collectors.toMap(t -> t.getId().toString(), t -> t, (t1, t2) -> t1));
        try {
            this.redisWrapper.apply(() -> {
                this.redisUtils.set(cacheKey, (Object)tenantMap);
                return null;
            }, null);
        }
        catch (Exception e) {
            logger.error("\u8bbe\u7f6e\u79df\u6237\u7f13\u5b58\u5931\u8d25\uff1a", (Throwable)e);
        }
    }

    private boolean delimiterMatch(String delimiterStr, String matcherStr) {
        if (CharSequenceUtil.isBlank((CharSequence)delimiterStr)) {
            return false;
        }
        for (String s : delimiterStr.split(",")) {
            if (!CharSequenceUtil.equals((CharSequence)s, (CharSequence)matcherStr)) continue;
            return true;
        }
        return false;
    }

    private List<SysTenantDTO> unmodified(List<SysTenantDTO> tenants) {
        if (tenants.isEmpty()) {
            return Collections.emptyList();
        }
        for (SysTenantDTO tenant : tenants) {
            if (tenant.getAppCodes() == null) {
                tenant.setAppCodes(Collections.emptySet());
                continue;
            }
            tenant.setAppCodes(Collections.unmodifiableSet(tenant.getAppCodes()));
        }
        return Collections.unmodifiableList(tenants);
    }
}

