/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.tenant.client.support.impl;

import com.elitescloud.boot.common.CloudtBootLoggerFactory;
import com.elitescloud.boot.flyway.common.FlywayBuilder;
import com.elitescloud.boot.flyway.common.FlywayHelper;
import com.elitescloud.boot.tenant.client.TenantClientProperties;
import com.elitescloud.boot.tenant.client.common.AbstractTenantDatasourceProvider;
import com.elitescloud.boot.tenant.client.common.TenantProvider;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import com.elitescloud.cloudt.system.dto.SysTenantDTO;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;

public class ClientSyncTenantProvider {
    private static final Logger logger = CloudtBootLoggerFactory.TENANT.getLogger(ClientSyncTenantProvider.class);
    private final TenantClientProperties clientProperties;
    private final TenantProvider tenantProvider;
    private final FlywayHelper flywayHelper;
    private final FlywayBuilder flywayBuilder;

    public ClientSyncTenantProvider(TenantClientProperties clientProperties, TenantProvider tenantProvider, FlywayHelper flywayHelper, FlywayBuilder flywayBuilder) {
        this.clientProperties = clientProperties;
        this.tenantProvider = tenantProvider;
        this.flywayHelper = flywayHelper;
        this.flywayBuilder = flywayBuilder;
    }

    public boolean sync() {
        try {
            this.executeSync();
            return true;
        }
        catch (Exception e) {
            logger.error("\u540c\u6b65\u5ba2\u6237\u7aef\u79df\u6237\u6570\u636e\u8868\u7ed3\u6784\u5f02\u5e38\uff1a", (Throwable)e);
            int times = 1;
            while (times < this.clientProperties.getSyncDbRetryTimes()) {
                try {
                    TimeUnit.SECONDS.sleep(this.clientProperties.getRetryInterval().getSeconds());
                    logger.info("\u91cd\u8bd5\u540c\u6b65\u5ba2\u6237\u7aef\u79df\u6237\u6570\u636e\u8868\u7ed3\u6784\u7b2c{}\u6b21...", (Object)times);
                    this.executeSync();
                    logger.info("\u91cd\u8bd5\u540c\u6b65\u5ba2\u6237\u7aef\u79df\u6237\u6570\u636e\u8868\u7ed3\u6784\u7b2c{}\u6b21\u6210\u529f\uff01", (Object)times);
                    return true;
                }
                catch (Exception e2) {
                    logger.error("\u7b2c" + times + "\u6b21\u540c\u6b65\u5ba2\u6237\u7aef\u79df\u6237\u6570\u636e\u8868\u7ed3\u6784\u5f02\u5e38\uff1a", (Throwable)e2);
                }
            }
            return false;
        }
    }

    private void executeSync() {
        Collection<SysTenantDTO> tenants = this.tenantProvider.getAllTenant().values();
        if (tenants.isEmpty()) {
            logger.warn("\u6682\u65e0\u79df\u6237\u4fe1\u606f");
            return;
        }
        for (SysTenantDTO tenant : tenants) {
            if (tenant.getIsolationStrategy() == null || tenant.getIsolationStrategy() != TenantIsolateStrategy.SCHEMA) {
                logger.info("\u79df\u6237\u3010{}, {}\u3011\u672a\u542f\u7528\u6570\u636e\u72ec\u7acbschema", (Object)tenant.getTenantName(), (Object)tenant.getId());
                continue;
            }
            this.flywayHelper.migrate(() -> this.flywayBuilder.createFlywayForTenant(AbstractTenantDatasourceProvider.getDefaultSchema(), tenant.getSchemaName()));
        }
    }
}

