/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.threadpool.common;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.dtp.common.config.ThreadPoolProperties;
import com.dtp.common.em.RejectedTypeEnum;
import com.dtp.core.DtpRegistry;
import com.dtp.core.support.ThreadPoolBuilder;
import com.dtp.core.support.wrapper.TaskWrapper;
import com.dtp.core.thread.DtpExecutor;
import com.dtp.core.thread.NamedThreadFactory;
import com.elitescloud.boot.threadpool.support.CloudtCoreTaskWrapper;
import java.util.List;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolHolder.class);
    public static final String THREAD_POOL_NAME = "cloudT-dtp-common";
    private static final String THREAD_PREFIX = "cloudT-common-";
    private static final int THREAD_MAX_SIZE = Runtime.getRuntime().availableProcessors();
    private static boolean dtpEnabled = true;

    protected ThreadPoolHolder() {
    }

    public static ThreadPoolExecutor createThreadPool() {
        return ThreadPoolHolder.createThreadPool(null, null, null);
    }

    public static ThreadPoolExecutor createThreadPool(String threadPrefix) {
        return ThreadPoolHolder.createThreadPool(threadPrefix, null, null);
    }

    public static ThreadPoolExecutor createThreadPool(String threadPrefix, Integer coreSize) {
        return ThreadPoolHolder.createThreadPool(threadPrefix, coreSize, null);
    }

    public static synchronized ThreadPoolExecutor createThreadPool(String threadPrefix, Integer coreSize, Integer maxSize) {
        return ThreadPoolHolder.createThreadPool(null, threadPrefix, coreSize, maxSize);
    }

    public static synchronized ThreadPoolExecutor createThreadPool(String threadPoolName, String threadPrefix, Integer coreSize, Integer maxSize) {
        return ThreadPoolHolder.createThreadPool(threadPoolName, threadPrefix, coreSize, maxSize, null);
    }

    public static synchronized ThreadPoolExecutor createThreadPool(String threadPoolName, String threadPrefix, Integer coreSize, Integer maxSize, Integer queueCapacity) {
        threadPrefix = CharSequenceUtil.blankToDefault((CharSequence)threadPrefix, (String)THREAD_PREFIX);
        threadPoolName = CharSequenceUtil.blankToDefault((CharSequence)threadPoolName, (String)(threadPrefix + THREAD_POOL_NAME));
        coreSize = (Integer)ObjectUtil.defaultIfNull((Object)coreSize, (Object)1);
        maxSize = (Integer)ObjectUtil.defaultIfNull((Object)maxSize, (Object)THREAD_MAX_SIZE);
        DtpExecutor executor = null;
        if (ThreadPoolHolder.existsRegistry(threadPoolName)) {
            executor = DtpRegistry.getDtpExecutor((String)threadPoolName);
        }
        ThreadPoolProperties propUpdate = null;
        if (executor == null) {
            LOG.info("create thread pool:{}, {}, {}, {}", new Object[]{threadPrefix, threadPoolName, coreSize, maxSize});
            executor = ThreadPoolBuilder.newBuilder().threadPoolName(threadPoolName).threadFactory(threadPrefix).corePoolSize(coreSize.intValue()).maximumPoolSize(maxSize.intValue()).queueCapacity(((Integer)ObjectUtil.defaultIfNull((Object)queueCapacity, (Object)256)).intValue()).ioIntensive(queueCapacity != null).taskWrappers(ThreadPoolHolder.taskWrappers()).rejectedExecutionHandler(RejectedTypeEnum.ABORT_POLICY.getName()).buildDynamic();
        } else {
            propUpdate = new ThreadPoolProperties();
            propUpdate.setCorePoolSize(coreSize.intValue());
            propUpdate.setMaximumPoolSize(maxSize.intValue());
            propUpdate.setThreadNamePrefix(threadPrefix);
        }
        if (dtpEnabled) {
            if (propUpdate == null) {
                DtpRegistry.registerDtp((DtpExecutor)executor, (String)"cloudt-common");
            } else {
                executor.setCorePoolSize(propUpdate.getCorePoolSize());
                executor.setMaximumPoolSize(propUpdate.getMaximumPoolSize());
                executor.setThreadFactory((ThreadFactory)new NamedThreadFactory(propUpdate.getThreadNamePrefix()));
                executor.setTaskWrappers(ThreadPoolHolder.taskWrappers());
            }
        }
        return executor;
    }

    private static boolean existsRegistry(String threadPoolName) {
        if (!dtpEnabled) {
            return false;
        }
        return DtpRegistry.listAllDtpNames().contains(threadPoolName);
    }

    private static List<TaskWrapper> taskWrappers() {
        return List.of(new CloudtCoreTaskWrapper());
    }
}

