/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.threadpool;

import com.dtp.common.config.DtpProperties;
import com.elitescloud.boot.threadpool.common.ThreadPoolHolder;
import com.elitescloud.boot.threadpool.support.ContextTransferDelegate;
import com.elitescloud.boot.threadpool.support.CustomTaskExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import org.springframework.beans.BeansException;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.lang.NonNull;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@AutoConfigureBefore(value={TaskExecutionAutoConfiguration.class})
public class ThreadPoolAutoConfiguration
implements ApplicationContextAware,
ApplicationRunner {
    public static final String BEAN_NAME = "cloudt_taskExecutor";
    private final DtpProperties dtpProperties;

    public ThreadPoolAutoConfiguration(DtpProperties dtpProperties) {
        this.dtpProperties = dtpProperties;
    }

    @Bean(value={"applicationTaskExecutor", "taskExecutor", "cloudt_taskExecutor"})
    @Primary
    public ThreadPoolTaskExecutor taskExecutor() {
        return new CustomTaskExecutor(this.dtpProperties);
    }

    @Bean
    public ThreadPoolExecutor cloudtDefaultDtpExecutor() {
        return ThreadPoolHolder.createThreadPool("cloudT-dtp-common", "cloudT-tp-", 8, 64);
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        ContextTransferDelegate.setApplicationContext(applicationContext);
    }

    public void run(ApplicationArguments args) throws Exception {
        ContextTransferDelegate.refreshContextTransfer();
    }
}

