/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.threadpool.support;

import cn.hutool.core.util.ArrayUtil;
import com.elitescloud.boot.threadpool.support.CloudtCoreTaskWrapper;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import org.dromara.dynamictp.core.aware.ExecutorAware;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.support.task.runnable.DtpRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudtDtpAware
implements ExecutorAware {
    private static final Logger logger = LoggerFactory.getLogger(CloudtDtpAware.class);
    private static final Map<String, Map<String, RunnableInfo>> runningMap = new HashMap<String, Map<String, RunnableInfo>>(64);

    public int getOrder() {
        return 0;
    }

    public String getName() {
        return "cloudt";
    }

    public static Map<String, Map<String, RunnableInfo>> getRunners() {
        HashMap<String, Map<String, RunnableInfo>> result = new HashMap<String, Map<String, RunnableInfo>>(runningMap.size());
        for (Map.Entry<String, Map<String, RunnableInfo>> entry : runningMap.entrySet()) {
            result.put(entry.getKey(), Collections.unmodifiableMap(entry.getValue()));
        }
        return result;
    }

    public void beforeExecute(Executor executor, Thread thread, Runnable runnable) {
        super.beforeExecute(executor, thread, runnable);
        if (!(executor instanceof DtpExecutor) || !(runnable instanceof DtpRunnable)) {
            return;
        }
        DtpExecutor dtpExecutor = (DtpExecutor)executor;
        DtpRunnable dtpRunnable = (DtpRunnable)runnable;
        Map runMap = runningMap.computeIfAbsent(dtpExecutor.getThreadPoolName(), k -> new HashMap());
        String key = thread.getName();
        if (key == null) {
            return;
        }
        runMap.put(key, new RunnableInfo(dtpRunnable, thread));
    }

    public void afterExecute(Executor executor, Runnable runnable, Throwable e) {
        super.afterExecute(executor, runnable, e);
        if (!(executor instanceof DtpExecutor) || !(runnable instanceof DtpRunnable)) {
            return;
        }
        DtpExecutor dtpExecutor = (DtpExecutor)executor;
        String key = Thread.currentThread().getName();
        if (key == null) {
            return;
        }
        runningMap.computeIfAbsent(dtpExecutor.getThreadPoolName(), k -> new HashMap()).remove(key);
    }

    public static class RunnableInfo {
        private final DtpRunnable runnable;
        private final Thread thread;
        private final StackTraceElement[] stackTraceElements;
        private final LocalDateTime startTime;

        public RunnableInfo(DtpRunnable runnable, Thread thread) {
            this.runnable = runnable;
            this.thread = thread;
            this.stackTraceElements = RunnableInfo.obtainStackTraceElements(runnable);
            this.startTime = LocalDateTime.now();
        }

        public String getName() {
            return this.runnable.getOriginRunnable().getClass().getName();
        }

        public Long getId() {
            return this.thread.getId();
        }

        public List<String> getStackNames() {
            if (ArrayUtil.isEmpty((Object[])this.stackTraceElements)) {
                return Collections.emptyList();
            }
            return Arrays.stream(this.stackTraceElements).map(t -> t.getClassName() + "." + t.getMethodName() + "#" + t.getLineNumber()).collect(Collectors.toList());
        }

        public LocalDateTime getStartTime() {
            return this.startTime;
        }

        private static StackTraceElement[] obtainStackTraceElements(DtpRunnable dtpRunnable) {
            Runnable runnable = dtpRunnable.getRunnable();
            if (runnable instanceof CloudtCoreTaskWrapper.CloudtRunnable) {
                return ((CloudtCoreTaskWrapper.CloudtRunnable)runnable).getStackTraceElements();
            }
            return new StackTraceElement[0];
        }
    }
}

