/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.threadpool.common;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.threadpool.support.CloudtCoreTaskWrapper;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.dromara.dynamictp.common.em.RejectedTypeEnum;
import org.dromara.dynamictp.common.queue.VariableLinkedBlockingQueue;
import org.dromara.dynamictp.core.DtpRegistry;
import org.dromara.dynamictp.core.executor.DtpExecutor;
import org.dromara.dynamictp.core.executor.NamedThreadFactory;
import org.dromara.dynamictp.core.support.ExecutorAdapter;
import org.dromara.dynamictp.core.support.ExecutorWrapper;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;
import org.dromara.dynamictp.core.support.task.wrapper.TaskWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadPoolHolder {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolHolder.class);
    public static final String THREAD_POOL_NAME = "cloudT-dtp-common";
    private static final String THREAD_PREFIX = "cloudT-common-";
    private static final int THREAD_MAX_SIZE = Runtime.getRuntime().availableProcessors();
    private static boolean dtpEnabled = true;

    protected ThreadPoolHolder() {
    }

    public static ThreadPoolExecutor createThreadPool() {
        return ThreadPoolHolder.createThreadPool(null, null, null);
    }

    public static ThreadPoolExecutor createThreadPool(String threadPrefix) {
        return ThreadPoolHolder.createThreadPool(threadPrefix, null, null);
    }

    public static ThreadPoolExecutor createThreadPool(String threadPrefix, Integer coreSize) {
        return ThreadPoolHolder.createThreadPool(threadPrefix, coreSize, null);
    }

    public static ThreadPoolExecutor createThreadPool(String threadPrefix, Integer coreSize, Integer maxSize) {
        return ThreadPoolHolder.createThreadPool(null, threadPrefix, coreSize, maxSize);
    }

    public static ThreadPoolExecutor createThreadPool(String threadPoolName, String threadPrefix, Integer coreSize, Integer maxSize) {
        return ThreadPoolHolder.createThreadPool(threadPoolName, threadPrefix, coreSize, maxSize, null);
    }

    public static ThreadPoolExecutor createThreadPool(String threadPoolName, String threadPrefix, Integer coreSize, Integer maxSize, Integer queueCapacity) {
        return ThreadPoolHolder.createThreadPool(threadPoolName, threadPrefix, coreSize, maxSize, queueCapacity, false, false, false, false);
    }

    public static ThreadPoolExecutor createThreadPoolEager(String threadPoolName, String threadPrefix, Integer coreSize, Integer maxSize, Integer queueCapacity) {
        return ThreadPoolHolder.createThreadPool(threadPoolName, threadPrefix, coreSize, maxSize, queueCapacity, true, false, false, false);
    }

    public static ThreadPoolExecutor createThreadPoolOrdered(String threadPoolName, String threadPrefix, Integer coreSize, Integer maxSize, Integer queueCapacity) {
        return ThreadPoolHolder.createThreadPool(threadPoolName, threadPrefix, coreSize, maxSize, queueCapacity, false, true, false, false);
    }

    public static ThreadPoolExecutor createThreadPoolPriority(String threadPoolName, String threadPrefix, Integer coreSize, Integer maxSize, Integer queueCapacity) {
        return ThreadPoolHolder.createThreadPool(threadPoolName, threadPrefix, coreSize, maxSize, queueCapacity, false, false, false, true);
    }

    public static ThreadPoolExecutor createThreadPoolScheduled(String threadPoolName, String threadPrefix, Integer coreSize, Integer maxSize, Integer queueCapacity) {
        return ThreadPoolHolder.createThreadPool(threadPoolName, threadPrefix, coreSize, maxSize, queueCapacity, false, false, true, false);
    }

    private static synchronized ThreadPoolExecutor createThreadPool(String threadPoolName, String threadPrefix, Integer coreSize, Integer maxSize, Integer queueCapacity, boolean eager, boolean order, boolean scheduled, boolean priority) {
        threadPrefix = CharSequenceUtil.blankToDefault((CharSequence)threadPrefix, (String)THREAD_PREFIX);
        threadPoolName = CharSequenceUtil.blankToDefault((CharSequence)threadPoolName, (String)(threadPrefix + THREAD_POOL_NAME));
        coreSize = (Integer)ObjectUtil.defaultIfNull((Object)coreSize, (Object)1);
        maxSize = (Integer)ObjectUtil.defaultIfNull((Object)maxSize, (Object)THREAD_MAX_SIZE);
        if (ThreadPoolHolder.existsRegistry(threadPoolName)) {
            ThreadPoolHolder.updateExecutor(threadPoolName, threadPrefix, coreSize, maxSize, queueCapacity);
            return DtpRegistry.getDtpExecutor((String)threadPoolName);
        }
        ThreadPoolBuilder executorBuilder = ThreadPoolBuilder.newBuilder().threadPoolName(threadPoolName).threadFactory(threadPrefix).corePoolSize(coreSize.intValue()).maximumPoolSize(maxSize.intValue()).queueCapacity(((Integer)ObjectUtil.defaultIfNull((Object)queueCapacity, (Object)256)).intValue()).taskWrappers(ThreadPoolHolder.taskWrappers()).rejectedExecutionHandler(RejectedTypeEnum.CALLER_RUNS_POLICY.getName()).awaitTerminationSeconds(30);
        Object executor = null;
        executor = eager ? executorBuilder.buildEager() : (order ? executorBuilder.buildOrdered() : (scheduled ? (DtpExecutor)executorBuilder.buildScheduled() : (priority ? executorBuilder.buildPriority() : executorBuilder.buildDynamic())));
        if (dtpEnabled) {
            DtpRegistry.registerExecutor((ExecutorWrapper)ExecutorWrapper.of((DtpExecutor)executor), (String)"cloudt");
        }
        return executor;
    }

    private static void updateExecutor(String threadPoolName, String threadPrefix, int coreSize, int maxSize, Integer queueCapacity) {
        int capacity;
        BlockingQueue queue;
        ExecutorAdapter executor = DtpRegistry.getExecutorWrapper((String)threadPoolName).getExecutor();
        executor.setCorePoolSize(coreSize);
        executor.setMaximumPoolSize(maxSize);
        if (executor instanceof DtpExecutor) {
            DtpExecutor dtpExecutor = (DtpExecutor)executor;
            dtpExecutor.setThreadFactory((ThreadFactory)new NamedThreadFactory(threadPrefix));
        }
        if ((queue = executor.getQueue()) instanceof VariableLinkedBlockingQueue && queueCapacity != null && !Objects.equals(capacity = queue.size() + queue.remainingCapacity(), queueCapacity)) {
            ((VariableLinkedBlockingQueue)queue).setCapacity(queueCapacity.intValue());
            executor.onRefreshQueueCapacity(queueCapacity.intValue());
        }
    }

    private static boolean existsRegistry(String threadPoolName) {
        if (!dtpEnabled) {
            return false;
        }
        return DtpRegistry.getAllExecutorNames().contains(threadPoolName);
    }

    private static List<TaskWrapper> taskWrappers() {
        return List.of(new CloudtCoreTaskWrapper());
    }
}

