# 数据库事务管理

### 编程式事务

> 推荐使用的是声明式事务，方便且易维护，但是在一些特殊情况下（如初始化bean时@PostConstruct或实现InitializingBean）无法使用声明式事务，则不得不使用编程式事务。

##### 通过TransactionTemplate

代码示例：

```
@Autowired
private PlatformTransactionManager transactionManager;


@PostConstruct
private void init() {
    logger.info("初始化操作开始...");
    TransactionTemplate transactionTemplate = new TransactionTemplate(transactionManager);
    transactionTemplate.executeWithoutResult(transactionStatus -> {
        // 自己的业务逻辑代码
    });
    logger.info("初始化操作结束！");
}
```

以上代码中使用的是executeWithoutResult()方法，即无返回结果，若需要返回结果，则可以使用execute()方法。

使用TransactionTemplate自动对事务进行了处理，如事务的提交和**异常（如RuntimeException、Error和Throwable）回滚**，若不满足需求，可直接使用DefaultTransactionDefinition来实现。

##### 通过DefaultTransactionDefinition

代码示例：

```
@Autowired
private PlatformTransactionManager transactionManager;


public Optional<String> createUserAsync() {
    // 设置隔离级别
    DefaultTransactionDefinition transactionDefinition = new DefaultTransactionDefinition();
    transactionDefinition.setPropagationBehavior(TransactionDefinition.PROPAGATION_REQUIRES_NEW);
    
    TransactionStatus transactionStatus = transactionManager.getTransaction(transactionDefinition);
    try {
        // 自己的业务逻辑
        
        // 最后提交事务
        transactionManager.commit(transactionStatus);
    } catch (Throwable throwable) {
        // 出现异常，则回滚事务
        transactionManager.rollback(transactionStatus);
    }
}
```



### 声明式事务

声明式事务目前提供了两种方式的支持。<mark>声明式事务依赖于Spring的AOP，所以在同一个类中通过非事务的方法调用事务的方法会失效。</mark>

##### 基于注解

在方法上加上注解`org.springframework.transaction.annotation.Transactional` 或 `javax.transaction.Transactional` 即可，使用注解时，请务必指定rollbackFor为Throwable，默认情况下rollback是RuntimeException和Error，所以对于部分异常会回滚失效。

##### 基于方法名

基于方法名的事务配置，配置前缀是elitesland.transaction，配置项：

- enable：是否开启基于方法名的事务配置，目前默认是关闭的。

- pointcut：切入点，默认值是"* com.elitesland..service..impl.*ServiceImpl.*(..)"，即在com.elitesland包下的任意子包service下的任意子impl包中，类名以ServiceImpl结尾中的所有方法均开启事务。

- timeout：事务超时时间，默认30秒。

- requiredMethodPrefix：写事务的方法名前缀，默认有["add", "insert", "create", "submit", "update", "modify", "edit", "save", "delete", "remove", "batch", "set", "exec", "import"]，以这些字符串开头的方法名对应的方法都会开启写事务。

- readonlyMethodPrefix：读事务的方法名前缀，默认有["get", "find", "query", "list", "page", "select", "count", "is", "exists", "all", "export"]，其余未匹配的默认都是只读事务。
  
  <mark>注意：如果读事务的方法名前缀会覆盖写事务的。</mark>






