/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.webservice.support;

import com.elitescloud.boot.webservice.WebServiceProperties;
import com.elitescloud.boot.webservice.support.ServiceProviderConfig;
import com.elitescloud.cloudt.common.base.annotation.webservice.WebServiceProvider;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.util.Assert;

public abstract class AbstractServiceProviderConfig
implements ServiceProviderConfig,
ApplicationRunner {
    private static final Logger log = LogManager.getLogger(AbstractServiceProviderConfig.class);
    protected WebServiceProperties properties;
    protected ApplicationContext applicationContext;

    public void run(ApplicationArguments args) throws Exception {
        Map beans = this.applicationContext.getBeansWithAnnotation(WebServiceProvider.class);
        if (beans.isEmpty()) {
            log.info("\u672a\u627e\u5230\u6709\u6548\u7684WebService\u670d\u52a1\u63d0\u4f9b\u8005");
        }
        for (Map.Entry entry : beans.entrySet()) {
            WebServiceProvider provider = entry.getValue().getClass().getAnnotation(WebServiceProvider.class);
            Assert.hasText((String)provider.path(), (String)((String)entry.getKey() + "\u7684address\u672a\u914d\u7f6e"));
            Assert.isTrue((boolean)provider.path().startsWith("/"), (String)((String)entry.getKey() + "\u7684address\u9700\u8981\u4ee5/\u5f00\u5934"));
            this.publishService(entry.getValue(), (String)entry.getKey(), provider);
            log.info("\u53d1\u5e03\u63a5\u53e3{} -> {}", entry.getKey(), (Object)provider.path());
        }
    }

    @Autowired
    public void setProperties(WebServiceProperties properties) {
        this.properties = properties;
    }

    @Autowired
    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

