/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.webservice.support.cxf;

import com.elitescloud.boot.webservice.support.AbstractServiceConsumerConfig;
import com.elitescloud.cloudt.common.base.annotation.webservice.WebServiceConsumer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import javax.jws.WebMethod;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.jaxws.endpoint.dynamic.JaxWsDynamicClientFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@ConditionalOnClass(value={JaxWsProxyFactoryBean.class})
public class CxfServiceConsumerConfig
extends AbstractServiceConsumerConfig {
    private static final Logger log = LogManager.getLogger(CxfServiceConsumerConfig.class);

    @Override
    public Object buildConsumer(@NonNull Class<?> serviceClass, String beanName, @NonNull WebServiceConsumer consumer) {
        if (consumer.javaServer()) {
            return this.buildStaticProxy(serviceClass, beanName, consumer);
        }
        return this.buildDynamicProxy(serviceClass, beanName, consumer);
    }

    private Object buildDynamicProxy(Class<?> serviceClass, String beanName, WebServiceConsumer consumer) {
        JaxWsDynamicClientFactory clientFactory = JaxWsDynamicClientFactory.newInstance();
        Client client = clientFactory.createClient(this.getAddress(consumer, beanName));
        HashMap methodNameCache = new HashMap(128);
        InvocationHandler handler = (proxy, method, args) -> {
            String tempName = serviceClass.getName() + "#" + method.getName();
            String methodName = methodNameCache.computeIfAbsent(tempName, k -> {
                WebMethod webMethod = method.getAnnotation(WebMethod.class);
                if (webMethod != null && StringUtils.hasText((String)webMethod.operationName())) {
                    return webMethod.operationName();
                }
                return method.getName();
            });
            return client.invoke(methodName, args);
        };
        return Proxy.newProxyInstance(serviceClass.getClassLoader(), new Class[]{serviceClass}, handler);
    }

    private Object buildStaticProxy(Class<?> serviceClass, String beanName, WebServiceConsumer consumer) {
        JaxWsProxyFactoryBean factoryBean = new JaxWsProxyFactoryBean();
        factoryBean.setServiceClass(serviceClass);
        String address = this.getAddress(consumer, beanName);
        factoryBean.setAddress(this.getAddress(consumer, beanName));
        log.info("WebService\u9759\u6001\u4ee3\u7406\u5ba2\u6237\u7aef\u3010{}\u3011\u7ed1\u5b9a\u5730\u5740\uff1a{}", (Object)beanName, (Object)address);
        return factoryBean.create();
    }

    private String getAddress(WebServiceConsumer consumer, String beanName) {
        if (StringUtils.hasText((String)consumer.addressKey())) {
            String address = this.getConfigAddress(consumer.addressKey());
            Assert.hasText((String)address, (String)(consumer.addressKey() + "\u672a\u914d\u7f6e"));
            return address;
        }
        Assert.hasText((String)consumer.address(), (String)(beanName + "\u7684addressKey()\u548caddress()\u81f3\u5c11\u914d\u7f6e\u4e00\u4e2a"));
        return consumer.address();
    }
}

