/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.websocket.support;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.provider.UserDetailProvider;
import com.elitescloud.cloudt.security.entity.GeneralUserDetails;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.server.HandshakeInterceptor;

public class AuthHandshakeInterceptor
implements HandshakeInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AuthHandshakeInterceptor.class);
    private final UserDetailProvider userDetailProvider;

    public AuthHandshakeInterceptor(UserDetailProvider userDetailProvider) {
        this.userDetailProvider = userDetailProvider;
    }

    public boolean beforeHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, @NonNull Map<String, Object> attributes) throws Exception {
        String token = this.obtainToken(request);
        if (StringUtils.hasText((String)token)) {
            GeneralUserDetails user = this.userDetailProvider.getByToken(token);
            log.info("WebSocket authenticated user\uff1a{}", (Object)(user == null ? null : user.getUsername()));
            if (user != null) {
                attributes.put("cloudt_user_deatil", user);
                return true;
            }
            return false;
        }
        return true;
    }

    public void afterHandshake(@NonNull ServerHttpRequest request, @NonNull ServerHttpResponse response, @NonNull WebSocketHandler wsHandler, Exception exception) {
    }

    private String obtainToken(ServerHttpRequest request) {
        String token;
        HttpHeaders headers = request.getHeaders();
        List authorization = headers.get((Object)"Authorization");
        String string = token = CollUtil.isEmpty((Collection)authorization) ? null : (String)authorization.get(0);
        if (CharSequenceUtil.isBlank((CharSequence)token)) {
            authorization = headers.get((Object)"Access-Token");
            token = CollUtil.isEmpty((Collection)authorization) ? null : (String)authorization.get(0);
        }
        return token;
    }
}

