package com.elitescloud.boot.xxljob;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.provider.TenantClientProvider;
import com.elitescloud.boot.xxljob.tenant.XxlJobTenantInterceptor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;

/**
 * 任务调度关于租户的配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/20/2023
 */
@ConditionalOnProperty(prefix = "elitesland.xxl-job", name = "enabled", havingValue = "true", matchIfMissing = true)
@ConditionalOnTenant
class CloudtTenantXxlJobAutoConfiguration {

    @Bean
    public XxlJobTenantInterceptor xxlJobTenantInterceptor(TenantClientProvider tenantClientProvider) {
        return new XxlJobTenantInterceptor(tenantClientProvider);
    }
}
