package com.elitescloud.boot.xxljob;

import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * xxl-job配置.
 *
 * @author Kaiser（wang shao）
 * @date 2023/1/6
 */
@ConfigurationProperties(prefix = XxlJobProperties.CONFIG_PREFIX)
class XxlJobProperties {
    public static final String CONFIG_PREFIX = "elitesland.xxl-job";

    /**
     * 是否启用
     */
    private Boolean enabled = true;

    /**
     * 调度中心地址
     */
    private String adminAddress;

    /**
     * token
     */
    private String accessToken;

    /**
     * 应用名称，默认取值spring.application.name
     */
    private String appname;

    /**
     * 调度访问地址（ip:port）
     */
    private String address;

    /**
     * 调度访问地址：ip地址
     */
    private String ip;

    /**
     * 调度访问地址：端口
     */
    private int port = 8865;

    /**
     * 日志文件路径
     */
    private String logPath;

    /**
     * 日志保留天数
     */
    private int logRetentionDays = 7;

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public String getAdminAddress() {
        return adminAddress;
    }

    public void setAdminAddress(String adminAddress) {
        this.adminAddress = adminAddress;
    }

    public String getAccessToken() {
        return accessToken;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public String getAppname() {
        return appname;
    }

    public void setAppname(String appname) {
        this.appname = appname;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public int getPort() {
        return port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getLogPath() {
        return logPath;
    }

    public void setLogPath(String logPath) {
        this.logPath = logPath;
    }

    public int getLogRetentionDays() {
        return logRetentionDays;
    }

    public void setLogRetentionDays(int logRetentionDays) {
        this.logRetentionDays = logRetentionDays;
    }
}
