/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.util;

import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.resource.ResourceUtil;
import cn.hutool.core.util.RuntimeUtil;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.connection.ReturnType;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.Assert;

public final class LimiterUtil {
    private static final Logger log = LogManager.getLogger(LimiterUtil.class);
    private static final ConcurrentHashMap<String, LimiterUtil> INSTANCE_MAP = new ConcurrentHashMap();
    private static final ConcurrentMap<String, AtomicLong> LOCAL_LIMITER = new ConcurrentHashMap<String, AtomicLong>();
    private static volatile boolean destroy = false;
    private static final byte[] LIMITER_BUSINESS = "{cloudt}:limiter".getBytes(StandardCharsets.UTF_8);
    private static byte[] luaScriptAdd;
    private static byte[] luaScriptSubtract;
    private final String key;
    private final byte[] keyBytes;
    private static RedisTemplate<Object, Object> redisTemplate;

    private LimiterUtil(String key, RedisTemplate<Object, Object> redisTemplate) {
        this.key = key;
        this.keyBytes = key.getBytes(StandardCharsets.UTF_8);
        LimiterUtil.redisTemplate = redisTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LimiterUtil getInstance(@NotNull RedisTemplate<Object, Object> redisTemplate, @NotBlank String key) {
        Assert.notNull(redisTemplate, (String)"redisTemplate\u4e3a\u7a7a");
        Assert.hasText((String)key, (String)"\u4e1a\u52a1\u6807\u8bc6\u4e3a\u7a7a");
        Class<LimiterUtil> clazz = LimiterUtil.class;
        synchronized (LimiterUtil.class) {
            LimiterUtil instance = INSTANCE_MAP.get(key);
            if (instance != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return instance;
            }
            instance = new LimiterUtil(key, redisTemplate);
            INSTANCE_MAP.put(key, instance);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return instance;
        }
    }

    public boolean updateLimiter(int max, int step, boolean add) {
        step = Math.max(step, 1);
        byte[] stepBytes = ("" + step).getBytes(StandardCharsets.UTF_8);
        byte[] maxBytes = ("" + max).getBytes(StandardCharsets.UTF_8);
        Long result = add ? (Long)redisTemplate.execute(connection -> (Long)connection.eval(luaScriptAdd, ReturnType.INTEGER, 1, (byte[][])new byte[][]{LIMITER_BUSINESS, this.keyBytes, maxBytes, stepBytes})) : (Long)redisTemplate.execute(connection -> (Long)connection.eval(luaScriptSubtract, ReturnType.INTEGER, 1, (byte[][])new byte[][]{LIMITER_BUSINESS, this.keyBytes, stepBytes}));
        if (result != null && result != -1L) {
            LOCAL_LIMITER.computeIfAbsent(this.key, k -> new AtomicLong(0L)).addAndGet((long)step * (add ? 1L : -1L));
            return true;
        }
        return false;
    }

    private static void shutdown() {
        if (destroy) {
            return;
        }
        destroy = true;
        log.info("\u6570\u636e\u5bfc\u5165\u5bfc\u51fa\u670d\u52a1\u9500\u6bc1...");
        for (Map.Entry entry : LOCAL_LIMITER.entrySet()) {
            LimiterUtil.clearLimiter((String)entry.getKey(), ((AtomicLong)entry.getValue()).intValue());
        }
    }

    private static void clearLimiter(String key, int value) {
        if (value <= 0) {
            return;
        }
        byte[] keyBytes = key.getBytes(StandardCharsets.UTF_8);
        byte[] valueBytes = ("" + value).getBytes(StandardCharsets.UTF_8);
        redisTemplate.execute(connection -> (Long)connection.eval(luaScriptSubtract, ReturnType.INTEGER, 1, (byte[][])new byte[][]{LIMITER_BUSINESS, keyBytes, valueBytes}));
    }

    static {
        try {
            luaScriptAdd = ResourceUtil.readBytes((String)"classpath:redis/limiter_add.lua");
            luaScriptSubtract = ResourceUtil.readBytes((String)"classpath:redis/limiter_subtract.lua");
        }
        catch (IORuntimeException e) {
            log.error("\u52a0\u8f7d\u9650\u6d41\u8d44\u6e90\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        RuntimeUtil.addShutdownHook(LimiterUtil::shutdown);
    }
}

