/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.support.app;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.provider.PlatformAppProvider;
import com.elitescloud.boot.support.app.CloudtAppHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.util.StringUtils;

public class CloudtAppConfig
implements InitializingBean,
ApplicationRunner {
    private static final Logger log = LogManager.getLogger(CloudtAppConfig.class);
    @Value(value="${spring.application.name:#{null}}")
    private String applicationName;
    private PlatformAppProvider appProvider;

    public void afterPropertiesSet() throws Exception {
        if (StringUtils.hasText((String)this.applicationName)) {
            CloudtAppHolder.setAppCode(this.applicationName);
        }
    }

    public void run(ApplicationArguments args) throws Exception {
        if (this.appProvider == null) {
            log.warn("{}\u672a\u627e\u5230\u6709\u6548\u5b9e\u73b0", (Object)PlatformAppProvider.class.getName());
            return;
        }
        String appCode = CloudtAppHolder.getAppCode();
        if (CharSequenceUtil.isBlank((CharSequence)appCode)) {
            return;
        }
        String appName = null;
        for (CodeNameParam codeNameParam : this.appProvider.all()) {
            if (!appCode.equals(codeNameParam.getCode())) continue;
            appName = codeNameParam.getName();
            break;
        }
        if (StringUtils.hasText(appName)) {
            CloudtAppHolder.setAppName(appName);
        }
    }

    @Autowired(required=false)
    public void setAppProvider(PlatformAppProvider appProvider) {
        this.appProvider = appProvider;
    }
}

