/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.support.serializer;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.annotation.BigDecimalFormat;
import com.elitescloud.boot.provider.DataFormatterProvider;
import com.elitescloud.boot.util.ArrayUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.springframework.util.ReflectionUtils;

public class BigDecimalSerializer
extends JsonSerializer<BigDecimal> {
    private final DataFormatterProvider formatterProvider;
    private final Map<Class<?>, Map<String, BigDecimalFormat>> cacheMap = new HashMap();

    public BigDecimalSerializer(DataFormatterProvider formatterProvider) {
        this.formatterProvider = formatterProvider;
    }

    public void serialize(BigDecimal value, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        if (value == null) {
            jsonGenerator.writeNumber((BigDecimal)null);
            return;
        }
        BigDecimal formattedValue = this.formatValue(value, jsonGenerator);
        jsonGenerator.writeNumber(formattedValue);
    }

    private BigDecimal formatValue(BigDecimal value, JsonGenerator jsonGenerator) {
        if (!this.formatterProvider.supportBigDecimal()) {
            return value;
        }
        BigDecimalFormat bigDecimalFormat = this.obtainBigDecimalFormat(jsonGenerator);
        return bigDecimalFormat == null ? value : this.formatterProvider.format(value, bigDecimalFormat);
    }

    private BigDecimalFormat obtainBigDecimalFormat(JsonGenerator jsonGenerator) {
        Object type = jsonGenerator.getCurrentValue();
        if (type == null) {
            return null;
        }
        JsonStreamContext context = jsonGenerator.getOutputContext();
        if (context == null) {
            return null;
        }
        String fieldName = context.getCurrentName();
        if (CharSequenceUtil.isBlank((CharSequence)fieldName)) {
            return null;
        }
        Class<?> typeClass = type.getClass();
        Map fieldMap = this.cacheMap.computeIfAbsent(typeClass, c -> new HashMap(64));
        if (fieldMap.containsKey(fieldName)) {
            return (BigDecimalFormat)fieldMap.get(fieldName);
        }
        Field field = ReflectionUtils.findField(typeClass, (String)fieldName);
        if (field == null) {
            return null;
        }
        Object[] annotations = (BigDecimalFormat[])field.getAnnotationsByType(BigDecimalFormat.class);
        Object annotation = ArrayUtil.isEmpty((Object[])annotations) ? null : annotations[0];
        fieldMap.put(fieldName, annotation);
        return annotation;
    }
}

