/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.context.util;

import cn.hutool.core.collection.CollUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.springframework.util.CollectionUtils;

public class CollectionUtil {
    private CollectionUtil() {
    }

    public static <E> void split(@NotEmpty List<E> collection, int size, @NotNull Consumer<List<E>> consumer) {
        int max;
        if (collection == null || collection.isEmpty()) {
            return;
        }
        if ((size = Integer.max(1, size)) >= (max = collection.size())) {
            consumer.accept(collection);
            return;
        }
        int index = 0;
        int tempMax = 0;
        ArrayList<E> sub = null;
        do {
            tempMax = Integer.min(index + size, max);
            sub = new ArrayList<E>(size);
            while (index < tempMax) {
                sub.add(collection.get(index));
                ++index;
            }
            consumer.accept(sub);
        } while (tempMax != max);
    }

    public static <E> List<E> expandTree(@NotEmpty List<E> collection, @NotNull Function<E, List<E>> getChildren) {
        if (CollectionUtils.isEmpty(collection)) {
            return Collections.emptyList();
        }
        ArrayList resultList = new ArrayList(128);
        CollectionUtil.expand(collection, getChildren, resultList);
        return resultList;
    }

    public static <E> List<E> filterChildrenForTree(List<E> respVoList, Function<E, List<E>> childrenGetter, BiConsumer<E, List<E>> childrenSetter, Predicate<E> predicate) {
        if (CollUtil.isEmpty(respVoList)) {
            return Collections.emptyList();
        }
        ArrayList<E> dataList = new ArrayList<E>();
        for (E t : respVoList) {
            boolean result = predicate.test(t);
            if (result) {
                dataList.add(t);
            }
            List<E> children = CollectionUtil.filterChildrenForTree(childrenGetter.apply(t), childrenGetter, childrenSetter, predicate);
            childrenSetter.accept(t, children);
            if (result || !CollUtil.isNotEmpty(children)) continue;
            dataList.add(t);
        }
        return dataList;
    }

    public static <E> List<E> sub(@NotEmpty Collection<E> collection, int offset, int size) {
        int end = offset + size;
        return CollUtil.sub(collection, (int)offset, (int)end);
    }

    public static <E> List<E> toList(E element, int size) {
        ArrayList<E> dataList = new ArrayList<E>(size);
        for (int i = 0; i < size; ++i) {
            dataList.add(element);
        }
        return dataList;
    }

    private static <E> void expand(@NotNull List<E> collection, @NotNull Function<E, List<E>> getChildren, List<E> resultList) {
        if (CollectionUtils.isEmpty(collection)) {
            return;
        }
        for (E e : collection) {
            resultList.add(e);
            CollectionUtil.expand(getChildren.apply(e), getChildren, resultList);
        }
        collection.clear();
    }
}

