/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.cloudt.context.util;

import com.elitescloud.boot.SpringContextHolder;
import java.util.Locale;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.lang.NonNull;

public class MessageSourceUtil {
    private static MessageSource messageSource;

    private MessageSourceUtil() {
    }

    public static String getMessage(@NonNull String code, Object ... args) {
        return MessageSourceUtil.getMessage(code, null, null, args);
    }

    public static String getMessage(@NonNull String code, String defaultMessage, Object ... args) {
        return MessageSourceUtil.getMessage(code, defaultMessage, null, args);
    }

    public static String getMessage(@NonNull String code, String defaultMessage, Locale locale, Object ... args) {
        MessageSource source = MessageSourceUtil.getMessageSource();
        if (locale == null) {
            locale = LocaleContextHolder.getLocale();
        }
        return source.getMessage(code, args, defaultMessage, locale);
    }

    private static MessageSource getMessageSource() {
        if (messageSource == null) {
            messageSource = SpringContextHolder.getBean(MessageSource.class);
        }
        return messageSource;
    }
}

