package com.elitescloud.boot.common.annotation;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.math.RoundingMode;

/**
 * BigDecimal格式化处理
 * <p>
 * 未使用的则使用其默认（原格式输出）
 *
 * @author chen.niu
 * @date 2023/9/20 16:22
 */
@Target(ElementType.FIELD)
@Retention(RetentionPolicy.RUNTIME)
public @interface BigDecimalFormat {

    /**
     * 数据含义类型
     *
     * @return 类型
     */
    BigDecimalType bdType() default BigDecimalType.CUSTOM;

    /**
     * 小数位位数
     * <p>
     * 默认保留8位，当 {@link #bdType()} 为 {@code CUSTOM} 时，此参数生效
     *
     * @return 位数
     */
    int scale() default 8;

    /**
     * 取舍类型
     * <p>
     * 默认四五五入，当 {@link #bdType()} 为 {@code CUSTOM} 时，此参数生效
     *
     * @return 取舍类型
     */
    RoundingMode roundingMode() default RoundingMode.HALF_UP;

    enum BigDecimalType {

        /**
         * 金额
         */
        AMOUNT,
        /**
         * 价格
         */
        PRICE,
        /**
         * 数量
         */
        QUANTITY,
        /**
         * 自定义
         */
        CUSTOM;
    }
}
