package com.elitescloud.boot.common.annotation.businessobject;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author : chen.niu
 * @description :  操作范围，定义操作是用于说明范围
 * @date : 2023-11-27 19:54
 */
public enum OperationScopeEnum {

    PUBLIC("公共"),
    PRIVATE_DOMAIN("领域私有"),
    PRIVATE_BUSINESS("指定业务私有"),
    PRIVATE_TEST("测试私有"),
    ELSE("其他"),

    ;

    /**
     * 描述
     */
    private final String description;

    OperationScopeEnum(String description) {
        this.description = description;
    }

    public String getDescription() {
        return description;
    }

    private static final Map<String, OperationScopeEnum> VALUE_MAP = Arrays.stream(values()).collect(Collectors.toMap(OperationScopeEnum::name, t -> t, (t1, t2) -> t1));

    public static OperationScopeEnum parse(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.get(value);
    }
}
