package com.elitescloud.boot.condition;

import com.elitescloud.boot.condition.support.OnTenantCondition;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import org.springframework.context.annotation.Conditional;

import java.lang.annotation.*;

/**
 * 租户相关环境条件.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/15
 */
@Retention(RetentionPolicy.RUNTIME)
@Target({ElementType.TYPE, ElementType.METHOD})
@Documented
@Inherited
@Conditional(OnTenantCondition.class)
public @interface ConditionalOnTenant {

    /**
     * 是否启用租户
     *
     * @return 是否启用租户
     */
    boolean enabled() default true;

    /**
     * 隔离策略
     *
     * @return 隔离策略
     */
    TenantIsolateStrategy[] isolateStrategy() default {};
}
