package com.elitescloud.boot.condition.support;

import com.elitescloud.boot.support.CloudtStarterTool;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;

import java.util.Map;

/**
 * 条件判断父类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/15
 */
public abstract class AbstractCondition extends SpringBootCondition {

    /**
     * 是否存在指定的属性
     *
     * @param attributes  属性
     * @param key         属性key
     * @param expectValue 期望值
     * @return 是否存在
     */
    protected boolean existsAttribute(@NonNull Map<String, Object> attributes, @NonNull String key, String expectValue) {
        return existsAttribute(attributes, key, null, expectValue);
    }

    /**
     * 是否存在指定的属性
     *
     * @param attributes   属性
     * @param key          属性key
     * @param defaultValue 默认值
     * @param expectValue  期望值
     * @return 是否存在
     */
    protected boolean existsAttribute(@NonNull Map<String, Object> attributes, @NonNull String key, String defaultValue, String expectValue) {
        Object val = attributes.getOrDefault(key, defaultValue);
        if (expectValue == null) {
            return val != null;
        }

        return val != null && val.toString().equals(expectValue);
    }

    /**
     * 是否存在指定的配置
     *
     * @param context     条件上下文
     * @param key         属性key
     * @param expectValue 期望值
     * @return 是否存在
     */
    protected boolean existsEnvironment(@NonNull ConditionContext context, @NonNull String key, String expectValue) {
        return existsEnvironment(context, key, null, expectValue);
    }

    /**
     * 是否存在指定的配置
     *
     * @param context     条件上下文
     * @param key         属性key
     * @param expectValue 期望值
     * @return 是否存在
     */
    protected boolean existsEnvironment(@NonNull ConditionContext context, @NonNull String key, String defaultValue, String expectValue) {
        return CloudtStarterTool.isPresentEnvironment(context.getEnvironment(), key, defaultValue, expectValue);
    }

    /**
     * 是否存在指定的类
     *
     * @param className   类的全限定名
     * @param classLoader classLoader
     * @return 是否存在
     */
    protected boolean isPresent(@NonNull String className, ClassLoader classLoader) {
        return CloudtStarterTool.isPresentClass(className, classLoader);
    }
}
