package com.elitescloud.boot.condition.support;

import com.elitescloud.boot.condition.ConditionalOnTenant;
import com.elitescloud.boot.constant.ClassNameConstant;
import com.elitescloud.cloudt.common.constant.TenantIsolateStrategy;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;

import java.util.Collections;
import java.util.Map;

/**
 * 租户条件处理.
 *
 * @author Kaiser（wang shao）
 * @date 2022/8/15
 */
public class OnTenantCondition extends AbstractCondition {

    private static final String CONFIG_PREFIX = "elitesland.tenant.client";

    @Override
    public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
        // 获取注解的属性
        var attributes = metadata.getAnnotationAttributes(ConditionalOnTenant.class.getName());
        if (attributes == null) {
            attributes = Collections.emptyMap();
        }

        // 要求启用租户时
        if (super.existsAttribute(attributes, "enabled", "true")) {
            boolean enabled = super.existsEnvironment(context, CONFIG_PREFIX + ".enabled", "true", "true")
                    && isPresent(ClassNameConstant.TENANT_CLIENT, null);
            if (enabled) {
                // 匹配策略
                if (this.matchIsolateStrategy(context, attributes)) {
                    return ConditionOutcome.match();
                }
                return ConditionOutcome.noMatch("租户的隔离策略不满足");
            }
            return ConditionOutcome.noMatch("未启用租户");
        }

        // 不要求启用租户时
        if (!super.existsEnvironment(context, CONFIG_PREFIX + ".enabled", "true", "true") ||
                !isPresent(ClassNameConstant.TENANT_CLIENT, null)) {
            return ConditionOutcome.match();
        }
        return ConditionOutcome.noMatch("已启用租户");
    }

    private boolean matchIsolateStrategy(ConditionContext context, Map<String, Object> attributes) {
        TenantIsolateStrategy[] strategies = (TenantIsolateStrategy[]) attributes.getOrDefault("isolateStrategy", new TenantIsolateStrategy[0]);
        if (strategies.length == 0) {
            // 没有设置策略，则默认满足
            return true;
        }

        String strategy = context.getEnvironment().getProperty(CONFIG_PREFIX + ".isolate-strategy", TenantIsolateStrategy.NONE.name());
        for (TenantIsolateStrategy tenantIsolateStrategy : strategies) {
            if (tenantIsolateStrategy.name().equals(strategy)) {
                return true;
            }
        }
        return false;
    }
}
