package com.elitescloud.boot.context;

import com.elitescloud.boot.common.servlet.CloudtRequestAttributes;
import org.springframework.web.context.request.RequestAttributes;

/**
 * Request上下文.
 *
 * @author Kaiser（wang shao）
 * @date 2023/12/28
 */
public class CloudtRequestContextHolder {
    private CloudtRequestContextHolder() {
    }

    private static final ThreadLocal<CloudtRequestAttributes> REQUEST_ATTRIBUTES_HOLDER = new ThreadLocal<>();

    /**
     * 设置当前请求
     */
    public static void setRequestAttributes(CloudtRequestAttributes requestAttributes) {
        if (requestAttributes == null) {
            requestAttributes = CloudtRequestAttributes.getInstance();
        }
        if (requestAttributes == null) {
            return;
        }

        REQUEST_ATTRIBUTES_HOLDER.set(requestAttributes);
    }

    /**
     * 获取当前的请求
     *
     * @return 请求对象
     */
    public static RequestAttributes getRequestAttributes() {
        var requestAttributes = REQUEST_ATTRIBUTES_HOLDER.get();
        if (requestAttributes == null) {
            return null;
        }

        return requestAttributes.getRequestAttributes();
    }

    /**
     * 清空上下文
     */
    public static void clear() {
        REQUEST_ATTRIBUTES_HOLDER.remove();
    }
}
