package com.elitescloud.boot.provider;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.common.annotation.BigDecimalFormat;

import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * 数据格式化.
 *
 * @author Kaiser（wang shao）
 * @date 2024/1/16
 */
public interface DataFormatterProvider {

    /**
     * 获取示例对象
     *
     * @return 实例对象
     */
    static DataFormatterProvider getInstance() {
        return ProviderHolder.getInstance();
    }

    /**
     * 是否支持BigDecimal
     *
     * @return 是否支持
     */
    boolean supportBigDecimal();

    /**
     * 格式化BigDecimal.
     *
     * @param value  待格式化的值
     * @param format 格式化配置注解
     * @return 格式化后的值
     */
    BigDecimal format(@NotNull BigDecimal value, BigDecimalFormat format);

    class ProviderHolder {
        private static DataFormatterProvider INSTANCE;

        private static DataFormatterProvider getInstance() {
            if (INSTANCE == null) {
                INSTANCE = SpringContextHolder.getObjectProvider(DataFormatterProvider.class).getIfAvailable();
            }
            return INSTANCE;
        }
    }
}
