package com.elitescloud.boot.provider;

import com.elitescloud.boot.SpringContextHolder;
import com.elitescloud.boot.provider.CloudtIdCreator;
import com.elitescloud.boot.provider.IdCreatable;

import java.io.Serializable;

/**
 * ID工程.
 *
 * @author Kaiser（wang shao）
 * @date 3/21/2023
 */
public class IdFactory {

    private static CloudtIdCreator cloudtIdCreator;
    private static IdCreatable<?> idCreatable;

    private IdFactory() {
    }

    /**
     * 生成ID
     *
     * @return ID
     */
    public static Serializable generate() {
        if (idCreatable == null) {
            idCreatable = SpringContextHolder.getBean(IdCreatable.class);
        }
        return idCreatable.create();
    }

    /**
     * 生成ID
     *
     * @return ID
     */
    public static Long generateLong() {
        if (cloudtIdCreator == null) {
            cloudtIdCreator = SpringContextHolder.getBean(CloudtIdCreator.class);
        }
        return cloudtIdCreator.create();
    }
}
