package com.elitescloud.boot.provider;

import com.elitescloud.cloudt.system.dto.SysTenantDTO;

import java.util.List;

/**
 * 租户客户端接口.
 *
 * @author Kaiser（wang shao）
 * @date 2022/4/16
 */
public interface TenantClientProvider {

    /**
     * 是否启用了租户
     *
     * @return 是否启用了租户
     */
    boolean enabledTenant();

    /**
     * 获取当前请求上下文中的租户
     *
     * @return 当前租户
     */
    SysTenantDTO getCurrentTenant();

    /**
     * 获取当前Session中的租户
     * <p>
     * 当上下文中的租户不满足时，通过数据隔离工具进行指定的租户
     *
     * @return 租户
     */
    SysTenantDTO getSessionTenant();

    /**
     * 获取租户信息
     *
     * @param sysTenantId 租户ID
     * @return 租户信息
     */
    SysTenantDTO getTenant(Long sysTenantId);

    /**
     * 根据租户编码获取租户
     *
     * @param tenantCode 租户编码
     * @return 租户信息
     */
    SysTenantDTO getTenantByCode(String tenantCode);

    /**
     * 获取所有租户信息
     *
     * @return 所有租户信息
     */
    List<SysTenantDTO> getAllTenants();

    /**
     * 从当前请求中获取租户信息
     *
     * @return 租户信息
     */
    SysTenantDTO obtainTenantFromRequest();

    /**
     * 是否是从默认的域名发起的请求
     *
     * @return 是否是从默认的域名发起的请求
     */
    boolean isDefaultDomainRequest();

    /**
     * 清理缓存
     */
    default void clearCache() {
    }
}
