package com.elitescloud.boot.support;

import cn.hutool.core.util.ArrayUtil;
import lombok.extern.log4j.Log4j2;
import org.springframework.boot.DefaultPropertiesPropertySource;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;

import java.util.Map;

/**
 * 环境变量处理.
 *
 * @author Kaiser（wang shao）
 * @date 2022/3/25
 */
@Log4j2
public abstract class AbstractEnvironmentPostProcessor implements EnvironmentPostProcessor {

    public static final String PROPERTY_SOURCE_NAME = DefaultPropertiesPropertySource.NAME;

    /**
     * Copy from BusEnvironmentPostProcessor#addOrReplace(MutablePropertySources, Map)
     *
     * @param propertySources {@link MutablePropertySources}
     * @param map             Default Dubbo Properties
     */
    protected static void addOrReplace(MutablePropertySources propertySources,
                                Map<String, Object> map) {
        MapPropertySource target = null;
        if (propertySources.contains(PROPERTY_SOURCE_NAME)) {
            PropertySource<?> source = propertySources.get(PROPERTY_SOURCE_NAME);
            if (source instanceof MapPropertySource) {
                target = (MapPropertySource) source;
                for (Map.Entry<String, Object> entry : map.entrySet()) {
                    if (!target.containsProperty(entry.getKey())) {
                        target.getSource().put(entry.getKey(), entry.getValue());
                    }
                }
            }
        }
        if (target == null) {
            target = new MapPropertySource(PROPERTY_SOURCE_NAME, map);
        }
        if (!propertySources.contains(PROPERTY_SOURCE_NAME)) {
            propertySources.addLast(target);
        }
    }

    protected static void removeProperty(ConfigurableEnvironment environment, String... keys) {
        if (ArrayUtil.isEmpty(keys)) {
            return;
        }

        PropertySource propertySource = environment.getPropertySources().get(PROPERTY_SOURCE_NAME);
        if (propertySource == null) {
            return;
        }
        Map<String, Object> source = (Map<String, Object>) propertySource.getSource();
        for (String key : keys) {
            source.remove(key);
        }
    }
}
