package com.elitescloud.boot.support.app;

import cn.hutool.core.text.CharSequenceUtil;
import com.elitescloud.boot.common.param.CodeNameParam;
import com.elitescloud.boot.provider.PlatformAppProvider;
import lombok.extern.log4j.Log4j2;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.util.StringUtils;

/**
 * 应用配置.
 *
 * @author Kaiser（wang shao）
 * @date 3/20/2023
 */
@Log4j2
public class CloudtAppConfig implements InitializingBean, ApplicationRunner {

    @Value("${spring.application.name:#{null}}")
    private String applicationName;

    private PlatformAppProvider appProvider;

    @Override
    public void afterPropertiesSet() throws Exception {
        // 设置应用编码
        if (StringUtils.hasText(applicationName)) {
            CloudtAppHolder.setAppCode(applicationName);
        }
    }

    @Override
    public void run(ApplicationArguments args) throws Exception {
        // 设置应用名称
        if (appProvider == null) {
            log.warn("{}未找到有效实现", PlatformAppProvider.class.getName());
            return;
        }
        String appCode = CloudtAppHolder.getAppCode();
        if (CharSequenceUtil.isBlank(appCode)) {
            return;
        }
        String appName = null;
        for (CodeNameParam codeNameParam : appProvider.all()) {
            if (appCode.equals(codeNameParam.getCode())) {
                appName = codeNameParam.getName();
                break;
            }
        }
        if (StringUtils.hasText(appName)) {
            CloudtAppHolder.setAppName(appName);
        }
    }

    @Autowired(required = false)
    public void setAppProvider(PlatformAppProvider appProvider) {
        this.appProvider = appProvider;
    }
}
