package com.elitescloud.cloudt.context.util;

import org.springframework.lang.NonNull;

/**
 * 缓存相关工具类.
 *
 * @author Kaiser（wang shao）
 * @date 2022/6/16
 */
public class CacheUtil {

    private CacheUtil() {
    }

    /**
     * 生成缓存key
     * <p>
     * spring的方法注解方式生成的缓存key名称
     *
     * @param params 所有参数
     * @return key
     */
    public static String generateKeyForMethod(@NonNull String... params) {
        return String.join("", params);
    }
}
