/*
 * Decompiled with CFR 0.152.
 */
package com.elitescloud.boot.context;

import java.io.Serializable;
import java.time.LocalDateTime;
import javax.validation.constraints.NotNull;
import org.slf4j.MDC;
import org.springframework.util.Assert;

public class ExecutorContextHolder {
    private static final ThreadLocal<ExecutorContext> CURRENT_THREAD = new ThreadLocal();
    private static final String MDC_NAME = "cloudt_source";

    public static ExecutorContext create(@NotNull Source source, ExecutorContext parent, boolean createIfPresent) {
        Assert.notNull((Object)((Object)source), (String)"\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        ExecutorContext executorContext = ExecutorContextHolder.get();
        if (executorContext == null) {
            executorContext = new ExecutorContext(source, parent);
            CURRENT_THREAD.set(executorContext);
            MDC.put((String)MDC_NAME, (String)source.name());
            return executorContext;
        }
        if (createIfPresent) {
            ExecutorContext executorContextChild = new ExecutorContext(source, executorContext);
            CURRENT_THREAD.set(executorContextChild);
            MDC.put((String)MDC_NAME, (String)source.name());
            return executorContextChild;
        }
        return executorContext;
    }

    public static ExecutorContext get() {
        return CURRENT_THREAD.get();
    }

    public static void clear() {
        CURRENT_THREAD.remove();
    }

    public static class ExecutorContext
    implements Serializable {
        private static final long serialVersionUID = -3606708282531782524L;
        private final LocalDateTime createTime;
        private final Source source;
        private final ExecutorContext parent;

        public ExecutorContext(Source source, ExecutorContext parent) {
            this.source = source;
            this.createTime = LocalDateTime.now();
            this.parent = parent;
        }

        public String toString() {
            return "ExecutorContext{createTime=" + this.createTime + ", source=" + this.source + ", parent=" + this.parent + "}";
        }

        public LocalDateTime getCreateTime() {
            return this.createTime;
        }

        public Source getSource() {
            return this.source;
        }

        public ExecutorContext getParent() {
            return this.parent;
        }
    }

    public static enum Source {
        WEB("Web"),
        WEB_RPC("RpcWeb"),
        WEB_SOCKET("WebSocket"),
        WEB_SERVICE("WebService"),
        XXL_JOB("XXL-JOB\u4efb\u52a1\u8c03\u5ea6"),
        MQ("MQ\u6d88\u606f\u961f\u5217"),
        SYNC("\u5f02\u6b65\u7ebf\u7a0b");

        private final String desc;

        private Source(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

